// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSubscriptionInner;
import com.azure.resourcemanager.appcontainers.models.DaprSubscription;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionBulkSubscribeOptions;
import com.azure.resourcemanager.appcontainers.models.DaprSubscriptionRoutes;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DaprSubscriptionImpl
    implements DaprSubscription, DaprSubscription.Definition, DaprSubscription.Update {
    private DaprSubscriptionInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String pubsubName() {
        return this.innerModel().pubsubName();
    }

    public String topic() {
        return this.innerModel().topic();
    }

    public String deadLetterTopic() {
        return this.innerModel().deadLetterTopic();
    }

    public DaprSubscriptionRoutes routes() {
        return this.innerModel().routes();
    }

    public List<String> scopes() {
        List<String> inner = this.innerModel().scopes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public Map<String, String> metadata() {
        Map<String, String> inner = this.innerModel().metadata();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public DaprSubscriptionBulkSubscribeOptions bulkSubscribe() {
        return this.innerModel().bulkSubscribe();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public DaprSubscriptionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String environmentName;

    private String name;

    public DaprSubscriptionImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    public DaprSubscription create() {
        this.innerObject = serviceManager.serviceClient()
            .getDaprSubscriptions()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, name, this.innerModel(), Context.NONE)
            .getValue();
        return this;
    }

    public DaprSubscription create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDaprSubscriptions()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, name, this.innerModel(), context)
            .getValue();
        return this;
    }

    DaprSubscriptionImpl(String name, com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new DaprSubscriptionInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    public DaprSubscriptionImpl update() {
        return this;
    }

    public DaprSubscription apply() {
        this.innerObject = serviceManager.serviceClient()
            .getDaprSubscriptions()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, name, this.innerModel(), Context.NONE)
            .getValue();
        return this;
    }

    public DaprSubscription apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDaprSubscriptions()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, name, this.innerModel(), context)
            .getValue();
        return this;
    }

    DaprSubscriptionImpl(DaprSubscriptionInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "daprSubscriptions");
    }

    public DaprSubscription refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getDaprSubscriptions()
            .getWithResponse(resourceGroupName, environmentName, name, Context.NONE)
            .getValue();
        return this;
    }

    public DaprSubscription refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDaprSubscriptions()
            .getWithResponse(resourceGroupName, environmentName, name, context)
            .getValue();
        return this;
    }

    public DaprSubscriptionImpl withPubsubName(String pubsubName) {
        this.innerModel().withPubsubName(pubsubName);
        return this;
    }

    public DaprSubscriptionImpl withTopic(String topic) {
        this.innerModel().withTopic(topic);
        return this;
    }

    public DaprSubscriptionImpl withDeadLetterTopic(String deadLetterTopic) {
        this.innerModel().withDeadLetterTopic(deadLetterTopic);
        return this;
    }

    public DaprSubscriptionImpl withRoutes(DaprSubscriptionRoutes routes) {
        this.innerModel().withRoutes(routes);
        return this;
    }

    public DaprSubscriptionImpl withScopes(List<String> scopes) {
        this.innerModel().withScopes(scopes);
        return this;
    }

    public DaprSubscriptionImpl withMetadata(Map<String, String> metadata) {
        this.innerModel().withMetadata(metadata);
        return this;
    }

    public DaprSubscriptionImpl withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions bulkSubscribe) {
        this.innerModel().withBulkSubscribe(bulkSubscribe);
        return this;
    }
}
