// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentInner;
import com.azure.resourcemanager.appcontainers.models.DotNetComponent;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentConfigurationProperty;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentServiceBind;
import com.azure.resourcemanager.appcontainers.models.DotNetComponentType;
import java.util.Collections;
import java.util.List;

public final class DotNetComponentImpl implements DotNetComponent, DotNetComponent.Definition, DotNetComponent.Update {
    private DotNetComponentInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public DotNetComponentType componentType() {
        return this.innerModel().componentType();
    }

    public DotNetComponentProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    public List<DotNetComponentConfigurationProperty> configurations() {
        List<DotNetComponentConfigurationProperty> inner = this.innerModel().configurations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<DotNetComponentServiceBind> serviceBinds() {
        List<DotNetComponentServiceBind> inner = this.innerModel().serviceBinds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public DotNetComponentInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String environmentName;

    private String name;

    public DotNetComponentImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    public DotNetComponent create() {
        this.innerObject = serviceManager.serviceClient()
            .getDotNetComponents()
            .createOrUpdate(resourceGroupName, environmentName, name, this.innerModel(), Context.NONE);
        return this;
    }

    public DotNetComponent create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDotNetComponents()
            .createOrUpdate(resourceGroupName, environmentName, name, this.innerModel(), context);
        return this;
    }

    DotNetComponentImpl(String name, com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new DotNetComponentInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    public DotNetComponentImpl update() {
        return this;
    }

    public DotNetComponent apply() {
        this.innerObject = serviceManager.serviceClient()
            .getDotNetComponents()
            .update(resourceGroupName, environmentName, name, this.innerModel(), Context.NONE);
        return this;
    }

    public DotNetComponent apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDotNetComponents()
            .update(resourceGroupName, environmentName, name, this.innerModel(), context);
        return this;
    }

    DotNetComponentImpl(DotNetComponentInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dotNetComponents");
    }

    public DotNetComponent refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getDotNetComponents()
            .getWithResponse(resourceGroupName, environmentName, name, Context.NONE)
            .getValue();
        return this;
    }

    public DotNetComponent refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDotNetComponents()
            .getWithResponse(resourceGroupName, environmentName, name, context)
            .getValue();
        return this;
    }

    public DotNetComponentImpl withComponentType(DotNetComponentType componentType) {
        this.innerModel().withComponentType(componentType);
        return this;
    }

    public DotNetComponentImpl withConfigurations(List<DotNetComponentConfigurationProperty> configurations) {
        this.innerModel().withConfigurations(configurations);
        return this;
    }

    public DotNetComponentImpl withServiceBinds(List<DotNetComponentServiceBind> serviceBinds) {
        this.innerModel().withServiceBinds(serviceBinds);
        return this;
    }
}
