// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appcontainers.fluent.FunctionsExtensionsClient;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in FunctionsExtensionsClient.
 */
public final class FunctionsExtensionsClientImpl implements FunctionsExtensionsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final FunctionsExtensionsService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerAppsApiClientImpl client;

    /**
     * Initializes an instance of FunctionsExtensionsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    FunctionsExtensionsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = RestProxy.create(FunctionsExtensionsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerAppsApiClientFunctionsExtensions to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerAppsApiClie")
    public interface FunctionsExtensionsService {
        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{containerAppName}/revisions/{revisionName}/providers/Microsoft.App/functions/{functionAppName}/invoke")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<String>> invokeFunctionsHost(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerAppName") String containerAppName, @PathParam("revisionName") String revisionName,
            @PathParam("functionAppName") String functionAppName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Proxies a Functions host call to the function app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param revisionName Name of the Container App Revision, the parent resource.
     * @param functionAppName Name of the Function App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<String>> invokeFunctionsHostWithResponseAsync(String resourceGroupName,
        String containerAppName, String revisionName, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.invokeFunctionsHost(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, containerAppName, revisionName, functionAppName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Proxies a Functions host call to the function app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param revisionName Name of the Container App Revision, the parent resource.
     * @param functionAppName Name of the Function App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<String>> invokeFunctionsHostWithResponseAsync(String resourceGroupName,
        String containerAppName, String revisionName, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerAppName is required and cannot be null."));
        }
        if (revisionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter revisionName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.invokeFunctionsHost(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, containerAppName, revisionName, functionAppName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Proxies a Functions host call to the function app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param revisionName Name of the Container App Revision, the parent resource.
     * @param functionAppName Name of the Function App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<String> invokeFunctionsHostAsync(String resourceGroupName, String containerAppName,
        String revisionName, String functionAppName) {
        return invokeFunctionsHostWithResponseAsync(resourceGroupName, containerAppName, revisionName, functionAppName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Proxies a Functions host call to the function app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param revisionName Name of the Container App Revision, the parent resource.
     * @param functionAppName Name of the Function App, the extension resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> invokeFunctionsHostWithResponse(String resourceGroupName, String containerAppName,
        String revisionName, String functionAppName, Context context) {
        return invokeFunctionsHostWithResponseAsync(resourceGroupName, containerAppName, revisionName, functionAppName,
            context).block();
    }

    /**
     * Proxies a Functions host call to the function app backed by the container app.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App.
     * @param revisionName Name of the Container App Revision, the parent resource.
     * @param functionAppName Name of the Function App, the extension resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String invokeFunctionsHost(String resourceGroupName, String containerAppName, String revisionName,
        String functionAppName) {
        return invokeFunctionsHostWithResponse(resourceGroupName, containerAppName, revisionName, functionAppName,
            Context.NONE).getValue();
    }
}
