// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.FunctionsExtensionsClient;
import com.azure.resourcemanager.appcontainers.models.FunctionsExtensions;

public final class FunctionsExtensionsImpl implements FunctionsExtensions {
    private static final ClientLogger LOGGER = new ClientLogger(FunctionsExtensionsImpl.class);

    private final FunctionsExtensionsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public FunctionsExtensionsImpl(FunctionsExtensionsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<String> invokeFunctionsHostWithResponse(String resourceGroupName, String containerAppName,
        String revisionName, String functionAppName, Context context) {
        return this.serviceClient()
            .invokeFunctionsHostWithResponse(resourceGroupName, containerAppName, revisionName, functionAppName,
                context);
    }

    public String invokeFunctionsHost(String resourceGroupName, String containerAppName, String revisionName,
        String functionAppName) {
        return this.serviceClient()
            .invokeFunctionsHost(resourceGroupName, containerAppName, revisionName, functionAppName);
    }

    private FunctionsExtensionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
