// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner;
import com.azure.resourcemanager.appcontainers.models.JavaComponent;
import com.azure.resourcemanager.appcontainers.models.JavaComponentProperties;

public final class JavaComponentImpl implements JavaComponent, JavaComponent.Definition, JavaComponent.Update {
    private JavaComponentInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public JavaComponentProperties properties() {
        return this.innerModel().properties();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public JavaComponentInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String environmentName;

    private String name;

    public JavaComponentImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    public JavaComponent create() {
        this.innerObject = serviceManager.serviceClient()
            .getJavaComponents()
            .createOrUpdate(resourceGroupName, environmentName, name, this.innerModel(), Context.NONE);
        return this;
    }

    public JavaComponent create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getJavaComponents()
            .createOrUpdate(resourceGroupName, environmentName, name, this.innerModel(), context);
        return this;
    }

    JavaComponentImpl(String name, com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new JavaComponentInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    public JavaComponentImpl update() {
        return this;
    }

    public JavaComponent apply() {
        this.innerObject = serviceManager.serviceClient()
            .getJavaComponents()
            .update(resourceGroupName, environmentName, name, this.innerModel(), Context.NONE);
        return this;
    }

    public JavaComponent apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getJavaComponents()
            .update(resourceGroupName, environmentName, name, this.innerModel(), context);
        return this;
    }

    JavaComponentImpl(JavaComponentInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "javaComponents");
    }

    public JavaComponent refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getJavaComponents()
            .getWithResponse(resourceGroupName, environmentName, name, Context.NONE)
            .getValue();
        return this;
    }

    public JavaComponent refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getJavaComponents()
            .getWithResponse(resourceGroupName, environmentName, name, context)
            .getValue();
        return this;
    }

    public JavaComponentImpl withProperties(JavaComponentProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}
