// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.JavaComponentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner;
import com.azure.resourcemanager.appcontainers.models.JavaComponent;
import com.azure.resourcemanager.appcontainers.models.JavaComponents;

public final class JavaComponentsImpl implements JavaComponents {
    private static final ClientLogger LOGGER = new ClientLogger(JavaComponentsImpl.class);

    private final JavaComponentsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public JavaComponentsImpl(JavaComponentsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<JavaComponent> list(String resourceGroupName, String environmentName) {
        PagedIterable<JavaComponentInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JavaComponentImpl(inner1, this.manager()));
    }

    public PagedIterable<JavaComponent> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<JavaComponentInner> inner
            = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JavaComponentImpl(inner1, this.manager()));
    }

    public Response<JavaComponent> getWithResponse(String resourceGroupName, String environmentName, String name,
        Context context) {
        Response<JavaComponentInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, environmentName, name, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new JavaComponentImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public JavaComponent get(String resourceGroupName, String environmentName, String name) {
        JavaComponentInner inner = this.serviceClient().get(resourceGroupName, environmentName, name);
        if (inner != null) {
            return new JavaComponentImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String environmentName, String name) {
        this.serviceClient().delete(resourceGroupName, environmentName, name);
    }

    public void delete(String resourceGroupName, String environmentName, String name, Context context) {
        this.serviceClient().delete(resourceGroupName, environmentName, name, context);
    }

    public JavaComponent getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "javaComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'javaComponents'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, name, Context.NONE).getValue();
    }

    public Response<JavaComponent> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "javaComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'javaComponents'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, name, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "javaComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'javaComponents'.", id)));
        }
        this.delete(resourceGroupName, environmentName, name, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "javaComponents");
        if (name == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'javaComponents'.", id)));
        }
        this.delete(resourceGroupName, environmentName, name, context);
    }

    private JavaComponentsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public JavaComponentImpl define(String name) {
        return new JavaComponentImpl(name, this.manager());
    }
}
