// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.JobInner;
import com.azure.resourcemanager.appcontainers.models.ContainerAppJobExecutions;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import com.azure.resourcemanager.appcontainers.models.Job;
import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobExecutionBase;
import com.azure.resourcemanager.appcontainers.models.JobExecutionTemplate;
import com.azure.resourcemanager.appcontainers.models.JobPatchProperties;
import com.azure.resourcemanager.appcontainers.models.JobPatchPropertiesProperties;
import com.azure.resourcemanager.appcontainers.models.JobProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JobSecretsCollection;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class JobImpl implements Job, Job.Definition, Job.Update {
    private JobInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public JobProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String environmentId() {
        return this.innerModel().environmentId();
    }

    public String workloadProfileName() {
        return this.innerModel().workloadProfileName();
    }

    public JobConfiguration configuration() {
        return this.innerModel().configuration();
    }

    public JobTemplate template() {
        return this.innerModel().template();
    }

    public List<String> outboundIpAddresses() {
        List<String> inner = this.innerModel().outboundIpAddresses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String eventStreamEndpoint() {
        return this.innerModel().eventStreamEndpoint();
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public JobInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String jobName;

    private JobPatchProperties updateJobEnvelope;

    public JobImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public Job create() {
        this.innerObject = serviceManager.serviceClient()
            .getJobs()
            .createOrUpdate(resourceGroupName, jobName, this.innerModel(), Context.NONE);
        return this;
    }

    public Job create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getJobs()
            .createOrUpdate(resourceGroupName, jobName, this.innerModel(), context);
        return this;
    }

    JobImpl(String name, com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new JobInner();
        this.serviceManager = serviceManager;
        this.jobName = name;
    }

    public JobImpl update() {
        this.updateJobEnvelope = new JobPatchProperties();
        return this;
    }

    public Job apply() {
        this.innerObject = serviceManager.serviceClient()
            .getJobs()
            .update(resourceGroupName, jobName, updateJobEnvelope, Context.NONE);
        return this;
    }

    public Job apply(Context context) {
        this.innerObject
            = serviceManager.serviceClient().getJobs().update(resourceGroupName, jobName, updateJobEnvelope, context);
        return this;
    }

    JobImpl(JobInner innerObject, com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.jobName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "jobs");
    }

    public Job refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getJobs()
            .getByResourceGroupWithResponse(resourceGroupName, jobName, Context.NONE)
            .getValue();
        return this;
    }

    public Job refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getJobs()
            .getByResourceGroupWithResponse(resourceGroupName, jobName, context)
            .getValue();
        return this;
    }

    public JobExecutionBase start() {
        return serviceManager.jobs().start(resourceGroupName, jobName);
    }

    public JobExecutionBase start(JobExecutionTemplate template, Context context) {
        return serviceManager.jobs().start(resourceGroupName, jobName, template, context);
    }

    public ContainerAppJobExecutions stopMultipleExecutions() {
        return serviceManager.jobs().stopMultipleExecutions(resourceGroupName, jobName);
    }

    public ContainerAppJobExecutions stopMultipleExecutions(Context context) {
        return serviceManager.jobs().stopMultipleExecutions(resourceGroupName, jobName, context);
    }

    public Response<JobSecretsCollection> listSecretsWithResponse(Context context) {
        return serviceManager.jobs().listSecretsWithResponse(resourceGroupName, jobName, context);
    }

    public JobSecretsCollection listSecrets() {
        return serviceManager.jobs().listSecrets(resourceGroupName, jobName);
    }

    public JobImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public JobImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public JobImpl withTags(Map<String, String> tags) {
        if (isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        } else {
            this.updateJobEnvelope.withTags(tags);
            return this;
        }
    }

    public JobImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        if (isInCreateMode()) {
            this.innerModel().withExtendedLocation(extendedLocation);
            return this;
        } else {
            this.updateJobEnvelope.withExtendedLocation(extendedLocation);
            return this;
        }
    }

    public JobImpl withIdentity(ManagedServiceIdentity identity) {
        if (isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        } else {
            this.updateJobEnvelope.withIdentity(identity);
            return this;
        }
    }

    public JobImpl withEnvironmentId(String environmentId) {
        this.innerModel().withEnvironmentId(environmentId);
        return this;
    }

    public JobImpl withWorkloadProfileName(String workloadProfileName) {
        this.innerModel().withWorkloadProfileName(workloadProfileName);
        return this;
    }

    public JobImpl withConfiguration(JobConfiguration configuration) {
        this.innerModel().withConfiguration(configuration);
        return this;
    }

    public JobImpl withTemplate(JobTemplate template) {
        this.innerModel().withTemplate(template);
        return this;
    }

    public JobImpl withProperties(JobPatchPropertiesProperties properties) {
        this.updateJobEnvelope.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
