// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appcontainers.fluent.JobsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppJobExecutionsInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsInner;
import com.azure.resourcemanager.appcontainers.fluent.models.JobExecutionBaseInner;
import com.azure.resourcemanager.appcontainers.fluent.models.JobInner;
import com.azure.resourcemanager.appcontainers.fluent.models.JobSecretsCollectionInner;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appcontainers.models.JobExecutionTemplate;
import com.azure.resourcemanager.appcontainers.models.JobPatchProperties;
import com.azure.resourcemanager.appcontainers.models.JobsCollection;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in JobsClient.
 */
public final class JobsClientImpl implements JobsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final JobsService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerAppsApiClientImpl client;

    /**
     * Initializes an instance of JobsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    JobsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = RestProxy.create(JobsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerAppsApiClientJobs to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerAppsApiClie")
    public interface JobsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectors")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticsCollectionInner>> listDetectors(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("jobName") String jobName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectors/{detectorName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticsInner>> getDetector(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("jobName") String jobName,
            @PathParam("detectorName") String detectorName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/detectorProperties/{apiName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<JobInner>> proxyGet(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("jobName") String jobName,
            @PathParam("apiName") String apiName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.App/jobs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<JobsCollection>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<JobsCollection>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<JobInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("jobName") String jobName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("jobName") String jobName,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") JobInner jobEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("jobName") String jobName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("jobName") String jobName,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") JobPatchProperties jobEnvelope,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/start")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> start(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("jobName") String jobName,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") JobExecutionTemplate template,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/executions/{jobExecutionName}/stop")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> stopExecution(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("api-version") String apiVersion,
            @PathParam("jobName") String jobName, @PathParam("jobExecutionName") String jobExecutionName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/stop")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> stopMultipleExecutions(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("api-version") String apiVersion,
            @PathParam("jobName") String jobName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/listSecrets")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<JobSecretsCollectionInner>> listSecrets(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("api-version") String apiVersion,
            @PathParam("jobName") String jobName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticsCollectionInner>> listDetectorsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<JobsCollection>> listBySubscriptionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<JobsCollection>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get the list of diagnostics for a given Container App Job.
     * 
     * Get the list of diagnostics for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Container App Job along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticsInner>> listDetectorsSinglePageAsync(String resourceGroupName,
        String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listDetectors(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, jobName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<DiagnosticsInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the list of diagnostics for a given Container App Job.
     * 
     * Get the list of diagnostics for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Container App Job along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticsInner>> listDetectorsSinglePageAsync(String resourceGroupName, String jobName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listDetectors(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the list of diagnostics for a given Container App Job.
     * 
     * Get the list of diagnostics for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Container App Job as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiagnosticsInner> listDetectorsAsync(String resourceGroupName, String jobName) {
        return new PagedFlux<>(() -> listDetectorsSinglePageAsync(resourceGroupName, jobName),
            nextLink -> listDetectorsNextSinglePageAsync(nextLink));
    }

    /**
     * Get the list of diagnostics for a given Container App Job.
     * 
     * Get the list of diagnostics for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Container App Job as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DiagnosticsInner> listDetectorsAsync(String resourceGroupName, String jobName, Context context) {
        return new PagedFlux<>(() -> listDetectorsSinglePageAsync(resourceGroupName, jobName, context),
            nextLink -> listDetectorsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get the list of diagnostics for a given Container App Job.
     * 
     * Get the list of diagnostics for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Container App Job as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiagnosticsInner> listDetectors(String resourceGroupName, String jobName) {
        return new PagedIterable<>(listDetectorsAsync(resourceGroupName, jobName));
    }

    /**
     * Get the list of diagnostics for a given Container App Job.
     * 
     * Get the list of diagnostics for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Container App Job as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DiagnosticsInner> listDetectors(String resourceGroupName, String jobName, Context context) {
        return new PagedIterable<>(listDetectorsAsync(resourceGroupName, jobName, context));
    }

    /**
     * Get the diagnostics data for a given Container App Job.
     * 
     * Get the diagnostics data for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param detectorName Name of the Container App Job detector.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Container App Job along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticsInner>> getDetectorWithResponseAsync(String resourceGroupName, String jobName,
        String detectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDetector(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, jobName, detectorName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the diagnostics data for a given Container App Job.
     * 
     * Get the diagnostics data for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param detectorName Name of the Container App Job detector.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Container App Job along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticsInner>> getDetectorWithResponseAsync(String resourceGroupName, String jobName,
        String detectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDetector(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            jobName, detectorName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the diagnostics data for a given Container App Job.
     * 
     * Get the diagnostics data for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param detectorName Name of the Container App Job detector.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Container App Job on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DiagnosticsInner> getDetectorAsync(String resourceGroupName, String jobName, String detectorName) {
        return getDetectorWithResponseAsync(resourceGroupName, jobName, detectorName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the diagnostics data for a given Container App Job.
     * 
     * Get the diagnostics data for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param detectorName Name of the Container App Job detector.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Container App Job along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticsInner> getDetectorWithResponse(String resourceGroupName, String jobName,
        String detectorName, Context context) {
        return getDetectorWithResponseAsync(resourceGroupName, jobName, detectorName, context).block();
    }

    /**
     * Get the diagnostics data for a given Container App Job.
     * 
     * Get the diagnostics data for a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param detectorName Name of the Container App Job detector.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Container App Job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticsInner getDetector(String resourceGroupName, String jobName, String detectorName) {
        return getDetectorWithResponse(resourceGroupName, jobName, detectorName, Context.NONE).getValue();
    }

    /**
     * Get the properties for a given Container App Job.
     * 
     * Get the properties of a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container App Job along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<JobInner>> proxyGetWithResponseAsync(String resourceGroupName, String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String apiName = "rootApi";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.proxyGet(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, jobName, apiName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the properties for a given Container App Job.
     * 
     * Get the properties of a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container App Job along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<JobInner>> proxyGetWithResponseAsync(String resourceGroupName, String jobName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String apiName = "rootApi";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.proxyGet(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName,
            apiName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the properties for a given Container App Job.
     * 
     * Get the properties of a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container App Job on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobInner> proxyGetAsync(String resourceGroupName, String jobName) {
        return proxyGetWithResponseAsync(resourceGroupName, jobName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the properties for a given Container App Job.
     * 
     * Get the properties of a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container App Job along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<JobInner> proxyGetWithResponse(String resourceGroupName, String jobName, Context context) {
        return proxyGetWithResponseAsync(resourceGroupName, jobName, context).block();
    }

    /**
     * Get the properties for a given Container App Job.
     * 
     * Get the properties of a Container App Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container App Job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobInner proxyGet(String resourceGroupName, String jobName) {
        return proxyGetWithResponse(resourceGroupName, jobName, Context.NONE).getValue();
    }

    /**
     * Get the Container Apps Jobs in a given subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given subscription along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<JobInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the Container Apps Jobs in a given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given subscription along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the Container Apps Jobs in a given subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<JobInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink));
    }

    /**
     * Get the Container Apps Jobs in a given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<JobInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context),
            nextLink -> listBySubscriptionNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get the Container Apps Jobs in a given subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<JobInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Get the Container Apps Jobs in a given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<JobInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Get the Container Apps Jobs in a given resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given resource group along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<JobInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the Container Apps Jobs in a given resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given resource group along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the Container Apps Jobs in a given resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<JobInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Get the Container Apps Jobs in a given resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<JobInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get the Container Apps Jobs in a given resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<JobInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Get the Container Apps Jobs in a given resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Container Apps Jobs in a given resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<JobInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Get the properties of a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container Apps Job along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<JobInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, jobName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the properties of a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container Apps Job along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<JobInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String jobName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            jobName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the properties of a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container Apps Job on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobInner> getByResourceGroupAsync(String resourceGroupName, String jobName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, jobName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the properties of a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container Apps Job along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<JobInner> getByResourceGroupWithResponse(String resourceGroupName, String jobName,
        Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, jobName, context).block();
    }

    /**
     * Get the properties of a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a Container Apps Job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobInner getByResourceGroup(String resourceGroupName, String jobName) {
        return getByResourceGroupWithResponse(resourceGroupName, jobName, Context.NONE).getValue();
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String jobName,
        JobInner jobEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobEnvelope == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobEnvelope is required and cannot be null."));
        } else {
            jobEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, jobName, this.client.getApiVersion(), jobEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String jobName,
        JobInner jobEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobEnvelope == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobEnvelope is required and cannot be null."));
        } else {
            jobEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            jobName, this.client.getApiVersion(), jobEnvelope, accept, context);
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App Job.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobInner>, JobInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String jobName, JobInner jobEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, jobName, jobEnvelope);
        return this.client.<JobInner, JobInner>getLroResult(mono, this.client.getHttpPipeline(), JobInner.class,
            JobInner.class, this.client.getContext());
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App Job.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobInner>, JobInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String jobName, JobInner jobEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, jobName, jobEnvelope, context);
        return this.client.<JobInner, JobInner>getLroResult(mono, this.client.getHttpPipeline(), JobInner.class,
            JobInner.class, context);
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App Job.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobInner>, JobInner> beginCreateOrUpdate(String resourceGroupName, String jobName,
        JobInner jobEnvelope) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, jobName, jobEnvelope).getSyncPoller();
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App Job.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobInner>, JobInner> beginCreateOrUpdate(String resourceGroupName, String jobName,
        JobInner jobEnvelope, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, jobName, jobEnvelope, context).getSyncPoller();
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobInner> createOrUpdateAsync(String resourceGroupName, String jobName, JobInner jobEnvelope) {
        return beginCreateOrUpdateAsync(resourceGroupName, jobName, jobEnvelope).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobInner> createOrUpdateAsync(String resourceGroupName, String jobName, JobInner jobEnvelope,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, jobName, jobEnvelope, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobInner createOrUpdate(String resourceGroupName, String jobName, JobInner jobEnvelope) {
        return createOrUpdateAsync(resourceGroupName, jobName, jobEnvelope).block();
    }

    /**
     * Create or Update a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobInner createOrUpdate(String resourceGroupName, String jobName, JobInner jobEnvelope, Context context) {
        return createOrUpdateAsync(resourceGroupName, jobName, jobEnvelope, context).block();
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, jobName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String jobName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String jobName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, jobName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String jobName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, jobName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String jobName) {
        return this.beginDeleteAsync(resourceGroupName, jobName).getSyncPoller();
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String jobName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, jobName, context).getSyncPoller();
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String jobName) {
        return beginDeleteAsync(resourceGroupName, jobName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String jobName, Context context) {
        return beginDeleteAsync(resourceGroupName, jobName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String jobName) {
        deleteAsync(resourceGroupName, jobName).block();
    }

    /**
     * Delete a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String jobName, Context context) {
        deleteAsync(resourceGroupName, jobName, context).block();
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String jobName,
        JobPatchProperties jobEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobEnvelope == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobEnvelope is required and cannot be null."));
        } else {
            jobEnvelope.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, jobName, this.client.getApiVersion(), jobEnvelope, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String jobName,
        JobPatchProperties jobEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobEnvelope == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobEnvelope is required and cannot be null."));
        } else {
            jobEnvelope.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName,
            this.client.getApiVersion(), jobEnvelope, accept, context);
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App Job.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobInner>, JobInner> beginUpdateAsync(String resourceGroupName, String jobName,
        JobPatchProperties jobEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, jobName, jobEnvelope);
        return this.client.<JobInner, JobInner>getLroResult(mono, this.client.getHttpPipeline(), JobInner.class,
            JobInner.class, this.client.getContext());
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App Job.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobInner>, JobInner> beginUpdateAsync(String resourceGroupName, String jobName,
        JobPatchProperties jobEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, jobName, jobEnvelope, context);
        return this.client.<JobInner, JobInner>getLroResult(mono, this.client.getHttpPipeline(), JobInner.class,
            JobInner.class, context);
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App Job.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobInner>, JobInner> beginUpdate(String resourceGroupName, String jobName,
        JobPatchProperties jobEnvelope) {
        return this.beginUpdateAsync(resourceGroupName, jobName, jobEnvelope).getSyncPoller();
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App Job.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobInner>, JobInner> beginUpdate(String resourceGroupName, String jobName,
        JobPatchProperties jobEnvelope, Context context) {
        return this.beginUpdateAsync(resourceGroupName, jobName, jobEnvelope, context).getSyncPoller();
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobInner> updateAsync(String resourceGroupName, String jobName, JobPatchProperties jobEnvelope) {
        return beginUpdateAsync(resourceGroupName, jobName, jobEnvelope).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobInner> updateAsync(String resourceGroupName, String jobName, JobPatchProperties jobEnvelope,
        Context context) {
        return beginUpdateAsync(resourceGroupName, jobName, jobEnvelope, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobInner update(String resourceGroupName, String jobName, JobPatchProperties jobEnvelope) {
        return updateAsync(resourceGroupName, jobName, jobEnvelope).block();
    }

    /**
     * Update properties of a Container Apps Job
     * 
     * Patches a Container Apps Job using JSON Merge Patch.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobEnvelope Properties used to create a container apps job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobInner update(String resourceGroupName, String jobName, JobPatchProperties jobEnvelope, Context context) {
        return updateAsync(resourceGroupName, jobName, jobEnvelope, context).block();
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param template Properties used to start a job execution.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App's Job execution name along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String jobName,
        JobExecutionTemplate template) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (template != null) {
            template.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.start(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, jobName, this.client.getApiVersion(), template, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param template Properties used to start a job execution.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App's Job execution name along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String jobName,
        JobExecutionTemplate template, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (template != null) {
            template.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.start(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, jobName,
            this.client.getApiVersion(), template, accept, context);
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param template Properties used to start a job execution.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App's Job execution name.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobExecutionBaseInner>, JobExecutionBaseInner>
        beginStartAsync(String resourceGroupName, String jobName, JobExecutionTemplate template) {
        Mono<Response<Flux<ByteBuffer>>> mono = startWithResponseAsync(resourceGroupName, jobName, template);
        return this.client.<JobExecutionBaseInner, JobExecutionBaseInner>getLroResult(mono,
            this.client.getHttpPipeline(), JobExecutionBaseInner.class, JobExecutionBaseInner.class,
            this.client.getContext());
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App's Job execution name.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobExecutionBaseInner>, JobExecutionBaseInner>
        beginStartAsync(String resourceGroupName, String jobName) {
        final JobExecutionTemplate template = null;
        Mono<Response<Flux<ByteBuffer>>> mono = startWithResponseAsync(resourceGroupName, jobName, template);
        return this.client.<JobExecutionBaseInner, JobExecutionBaseInner>getLroResult(mono,
            this.client.getHttpPipeline(), JobExecutionBaseInner.class, JobExecutionBaseInner.class,
            this.client.getContext());
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param template Properties used to start a job execution.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App's Job execution name.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobExecutionBaseInner>, JobExecutionBaseInner>
        beginStartAsync(String resourceGroupName, String jobName, JobExecutionTemplate template, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = startWithResponseAsync(resourceGroupName, jobName, template, context);
        return this.client.<JobExecutionBaseInner, JobExecutionBaseInner>getLroResult(mono,
            this.client.getHttpPipeline(), JobExecutionBaseInner.class, JobExecutionBaseInner.class, context);
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App's Job execution name.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobExecutionBaseInner>, JobExecutionBaseInner> beginStart(String resourceGroupName,
        String jobName) {
        final JobExecutionTemplate template = null;
        return this.beginStartAsync(resourceGroupName, jobName, template).getSyncPoller();
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param template Properties used to start a job execution.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App's Job execution name.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobExecutionBaseInner>, JobExecutionBaseInner> beginStart(String resourceGroupName,
        String jobName, JobExecutionTemplate template, Context context) {
        return this.beginStartAsync(resourceGroupName, jobName, template, context).getSyncPoller();
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param template Properties used to start a job execution.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App's Job execution name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobExecutionBaseInner> startAsync(String resourceGroupName, String jobName,
        JobExecutionTemplate template) {
        return beginStartAsync(resourceGroupName, jobName, template).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App's Job execution name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobExecutionBaseInner> startAsync(String resourceGroupName, String jobName) {
        final JobExecutionTemplate template = null;
        return beginStartAsync(resourceGroupName, jobName, template).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param template Properties used to start a job execution.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App's Job execution name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobExecutionBaseInner> startAsync(String resourceGroupName, String jobName,
        JobExecutionTemplate template, Context context) {
        return beginStartAsync(resourceGroupName, jobName, template, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App's Job execution name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobExecutionBaseInner start(String resourceGroupName, String jobName) {
        final JobExecutionTemplate template = null;
        return startAsync(resourceGroupName, jobName, template).block();
    }

    /**
     * Start a Container Apps Job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param template Properties used to start a job execution.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App's Job execution name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobExecutionBaseInner start(String resourceGroupName, String jobName, JobExecutionTemplate template,
        Context context) {
        return startAsync(resourceGroupName, jobName, template, context).block();
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopExecutionWithResponseAsync(String resourceGroupName, String jobName,
        String jobExecutionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter jobExecutionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.stopExecution(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, this.client.getApiVersion(), jobName, jobExecutionName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopExecutionWithResponseAsync(String resourceGroupName, String jobName,
        String jobExecutionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter jobExecutionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.stopExecution(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            this.client.getApiVersion(), jobName, jobExecutionName, accept, context);
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStopExecutionAsync(String resourceGroupName, String jobName,
        String jobExecutionName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = stopExecutionWithResponseAsync(resourceGroupName, jobName, jobExecutionName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStopExecutionAsync(String resourceGroupName, String jobName,
        String jobExecutionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = stopExecutionWithResponseAsync(resourceGroupName, jobName, jobExecutionName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStopExecution(String resourceGroupName, String jobName,
        String jobExecutionName) {
        return this.beginStopExecutionAsync(resourceGroupName, jobName, jobExecutionName).getSyncPoller();
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStopExecution(String resourceGroupName, String jobName,
        String jobExecutionName, Context context) {
        return this.beginStopExecutionAsync(resourceGroupName, jobName, jobExecutionName, context).getSyncPoller();
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> stopExecutionAsync(String resourceGroupName, String jobName, String jobExecutionName) {
        return beginStopExecutionAsync(resourceGroupName, jobName, jobExecutionName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> stopExecutionAsync(String resourceGroupName, String jobName, String jobExecutionName,
        Context context) {
        return beginStopExecutionAsync(resourceGroupName, jobName, jobExecutionName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stopExecution(String resourceGroupName, String jobName, String jobExecutionName) {
        stopExecutionAsync(resourceGroupName, jobName, jobExecutionName).block();
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param jobExecutionName Job execution name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stopExecution(String resourceGroupName, String jobName, String jobExecutionName, Context context) {
        stopExecutionAsync(resourceGroupName, jobName, jobExecutionName, context).block();
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App executions collection ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopMultipleExecutionsWithResponseAsync(String resourceGroupName,
        String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.stopMultipleExecutions(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, this.client.getApiVersion(), jobName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App executions collection ARM resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopMultipleExecutionsWithResponseAsync(String resourceGroupName,
        String jobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.stopMultipleExecutions(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, this.client.getApiVersion(), jobName, accept, context);
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App executions collection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ContainerAppJobExecutionsInner>, ContainerAppJobExecutionsInner>
        beginStopMultipleExecutionsAsync(String resourceGroupName, String jobName) {
        Mono<Response<Flux<ByteBuffer>>> mono = stopMultipleExecutionsWithResponseAsync(resourceGroupName, jobName);
        return this.client.<ContainerAppJobExecutionsInner, ContainerAppJobExecutionsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ContainerAppJobExecutionsInner.class, ContainerAppJobExecutionsInner.class,
            this.client.getContext());
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of container App executions collection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ContainerAppJobExecutionsInner>, ContainerAppJobExecutionsInner>
        beginStopMultipleExecutionsAsync(String resourceGroupName, String jobName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = stopMultipleExecutionsWithResponseAsync(resourceGroupName, jobName, context);
        return this.client.<ContainerAppJobExecutionsInner, ContainerAppJobExecutionsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ContainerAppJobExecutionsInner.class, ContainerAppJobExecutionsInner.class,
            context);
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App executions collection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ContainerAppJobExecutionsInner>, ContainerAppJobExecutionsInner>
        beginStopMultipleExecutions(String resourceGroupName, String jobName) {
        return this.beginStopMultipleExecutionsAsync(resourceGroupName, jobName).getSyncPoller();
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of container App executions collection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ContainerAppJobExecutionsInner>, ContainerAppJobExecutionsInner>
        beginStopMultipleExecutions(String resourceGroupName, String jobName, Context context) {
        return this.beginStopMultipleExecutionsAsync(resourceGroupName, jobName, context).getSyncPoller();
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App executions collection ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ContainerAppJobExecutionsInner> stopMultipleExecutionsAsync(String resourceGroupName, String jobName) {
        return beginStopMultipleExecutionsAsync(resourceGroupName, jobName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App executions collection ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ContainerAppJobExecutionsInner> stopMultipleExecutionsAsync(String resourceGroupName, String jobName,
        Context context) {
        return beginStopMultipleExecutionsAsync(resourceGroupName, jobName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App executions collection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerAppJobExecutionsInner stopMultipleExecutions(String resourceGroupName, String jobName) {
        return stopMultipleExecutionsAsync(resourceGroupName, jobName).block();
    }

    /**
     * Terminates execution of a running container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App executions collection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerAppJobExecutionsInner stopMultipleExecutions(String resourceGroupName, String jobName,
        Context context) {
        return stopMultipleExecutionsAsync(resourceGroupName, jobName, context).block();
    }

    /**
     * List secrets for a container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Job Secrets Collection ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<JobSecretsCollectionInner>> listSecretsWithResponseAsync(String resourceGroupName,
        String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSecrets(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, this.client.getApiVersion(), jobName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List secrets for a container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Job Secrets Collection ARM resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<JobSecretsCollectionInner>> listSecretsWithResponseAsync(String resourceGroupName,
        String jobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listSecrets(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            this.client.getApiVersion(), jobName, accept, context);
    }

    /**
     * List secrets for a container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Job Secrets Collection ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<JobSecretsCollectionInner> listSecretsAsync(String resourceGroupName, String jobName) {
        return listSecretsWithResponseAsync(resourceGroupName, jobName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * List secrets for a container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Job Secrets Collection ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<JobSecretsCollectionInner> listSecretsWithResponse(String resourceGroupName, String jobName,
        Context context) {
        return listSecretsWithResponseAsync(resourceGroupName, jobName, context).block();
    }

    /**
     * List secrets for a container apps job.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param jobName Job Name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Job Secrets Collection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public JobSecretsCollectionInner listSecrets(String resourceGroupName, String jobName) {
        return listSecretsWithResponse(resourceGroupName, jobName, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return diagnostics data collection for a resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticsInner>> listDetectorsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listDetectorsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DiagnosticsInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return diagnostics data collection for a resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DiagnosticsInner>> listDetectorsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listDetectorsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Jobs collection ARM resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<JobInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Jobs collection ARM resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Jobs collection ARM resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<JobInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container Apps Jobs collection ARM resource along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<JobInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
