// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.JobsExecutionsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.JobExecutionInner;
import com.azure.resourcemanager.appcontainers.models.JobExecution;
import com.azure.resourcemanager.appcontainers.models.JobsExecutions;

public final class JobsExecutionsImpl implements JobsExecutions {
    private static final ClientLogger LOGGER = new ClientLogger(JobsExecutionsImpl.class);

    private final JobsExecutionsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public JobsExecutionsImpl(JobsExecutionsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<JobExecution> list(String resourceGroupName, String jobName) {
        PagedIterable<JobExecutionInner> inner = this.serviceClient().list(resourceGroupName, jobName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobExecutionImpl(inner1, this.manager()));
    }

    public PagedIterable<JobExecution> list(String resourceGroupName, String jobName, String filter, Context context) {
        PagedIterable<JobExecutionInner> inner = this.serviceClient().list(resourceGroupName, jobName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JobExecutionImpl(inner1, this.manager()));
    }

    private JobsExecutionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
