// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.LogicAppsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.LogicAppInner;
import com.azure.resourcemanager.appcontainers.fluent.models.WorkflowEnvelopeInner;
import com.azure.resourcemanager.appcontainers.models.LogicApp;
import com.azure.resourcemanager.appcontainers.models.LogicApps;
import com.azure.resourcemanager.appcontainers.models.LogicAppsProxyMethod;
import com.azure.resourcemanager.appcontainers.models.WorkflowArtifacts;
import com.azure.resourcemanager.appcontainers.models.WorkflowEnvelope;

public final class LogicAppsImpl implements LogicApps {
    private static final ClientLogger LOGGER = new ClientLogger(LogicAppsImpl.class);

    private final LogicAppsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public LogicAppsImpl(LogicAppsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<LogicApp> getWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        Context context) {
        Response<LogicAppInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, containerAppName, logicAppName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new LogicAppImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public LogicApp get(String resourceGroupName, String containerAppName, String logicAppName) {
        LogicAppInner inner = this.serviceClient().get(resourceGroupName, containerAppName, logicAppName);
        if (inner != null) {
            return new LogicAppImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, containerAppName, logicAppName, context);
    }

    public void delete(String resourceGroupName, String containerAppName, String logicAppName) {
        this.serviceClient().delete(resourceGroupName, containerAppName, logicAppName);
    }

    public PagedIterable<WorkflowEnvelope> listWorkflows(String resourceGroupName, String containerAppName,
        String logicAppName) {
        PagedIterable<WorkflowEnvelopeInner> inner
            = this.serviceClient().listWorkflows(resourceGroupName, containerAppName, logicAppName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkflowEnvelopeImpl(inner1, this.manager()));
    }

    public PagedIterable<WorkflowEnvelope> listWorkflows(String resourceGroupName, String containerAppName,
        String logicAppName, Context context) {
        PagedIterable<WorkflowEnvelopeInner> inner
            = this.serviceClient().listWorkflows(resourceGroupName, containerAppName, logicAppName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkflowEnvelopeImpl(inner1, this.manager()));
    }

    public Response<WorkflowEnvelope> getWorkflowWithResponse(String resourceGroupName, String containerAppName,
        String logicAppName, String workflowName, Context context) {
        Response<WorkflowEnvelopeInner> inner = this.serviceClient()
            .getWorkflowWithResponse(resourceGroupName, containerAppName, logicAppName, workflowName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new WorkflowEnvelopeImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public WorkflowEnvelope getWorkflow(String resourceGroupName, String containerAppName, String logicAppName,
        String workflowName) {
        WorkflowEnvelopeInner inner
            = this.serviceClient().getWorkflow(resourceGroupName, containerAppName, logicAppName, workflowName);
        if (inner != null) {
            return new WorkflowEnvelopeImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deployWorkflowArtifactsWithResponse(String resourceGroupName, String containerAppName,
        String logicAppName, WorkflowArtifacts workflowArtifacts, Context context) {
        return this.serviceClient()
            .deployWorkflowArtifactsWithResponse(resourceGroupName, containerAppName, logicAppName, workflowArtifacts,
                context);
    }

    public void deployWorkflowArtifacts(String resourceGroupName, String containerAppName, String logicAppName) {
        this.serviceClient().deployWorkflowArtifacts(resourceGroupName, containerAppName, logicAppName);
    }

    public Response<WorkflowEnvelope> listWorkflowsConnectionsWithResponse(String resourceGroupName,
        String containerAppName, String logicAppName, Context context) {
        Response<WorkflowEnvelopeInner> inner = this.serviceClient()
            .listWorkflowsConnectionsWithResponse(resourceGroupName, containerAppName, logicAppName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new WorkflowEnvelopeImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public WorkflowEnvelope listWorkflowsConnections(String resourceGroupName, String containerAppName,
        String logicAppName) {
        WorkflowEnvelopeInner inner
            = this.serviceClient().listWorkflowsConnections(resourceGroupName, containerAppName, logicAppName);
        if (inner != null) {
            return new WorkflowEnvelopeImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Object> invokeWithResponse(String resourceGroupName, String containerAppName, String logicAppName,
        String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod, Context context) {
        return this.serviceClient()
            .invokeWithResponse(resourceGroupName, containerAppName, logicAppName, xMsLogicAppsProxyPath,
                xMsLogicAppsProxyMethod, context);
    }

    public Object invoke(String resourceGroupName, String containerAppName, String logicAppName,
        String xMsLogicAppsProxyPath, LogicAppsProxyMethod xMsLogicAppsProxyMethod) {
        return this.serviceClient()
            .invoke(resourceGroupName, containerAppName, logicAppName, xMsLogicAppsProxyPath, xMsLogicAppsProxyMethod);
    }

    public LogicApp getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String logicAppName = ResourceManagerUtils.getValueFromIdByName(id, "logicApps");
        if (logicAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'logicApps'.", id)));
        }
        return this.getWithResponse(resourceGroupName, containerAppName, logicAppName, Context.NONE).getValue();
    }

    public Response<LogicApp> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String logicAppName = ResourceManagerUtils.getValueFromIdByName(id, "logicApps");
        if (logicAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'logicApps'.", id)));
        }
        return this.getWithResponse(resourceGroupName, containerAppName, logicAppName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String logicAppName = ResourceManagerUtils.getValueFromIdByName(id, "logicApps");
        if (logicAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'logicApps'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, containerAppName, logicAppName, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String containerAppName = ResourceManagerUtils.getValueFromIdByName(id, "containerApps");
        if (containerAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'containerApps'.", id)));
        }
        String logicAppName = ResourceManagerUtils.getValueFromIdByName(id, "logicApps");
        if (logicAppName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'logicApps'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, containerAppName, logicAppName, context);
    }

    private LogicAppsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public LogicAppImpl define(String name) {
        return new LogicAppImpl(name, this.manager());
    }
}
