// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedCertificateInner;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificate;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificatePatch;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificateProperties;
import java.util.Collections;
import java.util.Map;

public final class ManagedCertificateImpl
    implements ManagedCertificate, ManagedCertificate.Definition, ManagedCertificate.Update {
    private ManagedCertificateInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public ManagedCertificateProperties properties() {
        return this.innerModel().properties();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ManagedCertificateInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String environmentName;

    private String managedCertificateName;

    private ManagedCertificatePatch updateManagedCertificateEnvelope;

    public ManagedCertificateImpl withExistingManagedEnvironment(String resourceGroupName, String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    public ManagedCertificate create() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedCertificates()
            .createOrUpdate(resourceGroupName, environmentName, managedCertificateName, this.innerModel(),
                Context.NONE);
        return this;
    }

    public ManagedCertificate create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedCertificates()
            .createOrUpdate(resourceGroupName, environmentName, managedCertificateName, this.innerModel(), context);
        return this;
    }

    ManagedCertificateImpl(String name,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new ManagedCertificateInner();
        this.serviceManager = serviceManager;
        this.managedCertificateName = name;
    }

    public ManagedCertificateImpl update() {
        this.updateManagedCertificateEnvelope = new ManagedCertificatePatch();
        return this;
    }

    public ManagedCertificate apply() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedCertificates()
            .updateWithResponse(resourceGroupName, environmentName, managedCertificateName,
                updateManagedCertificateEnvelope, Context.NONE)
            .getValue();
        return this;
    }

    public ManagedCertificate apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedCertificates()
            .updateWithResponse(resourceGroupName, environmentName, managedCertificateName,
                updateManagedCertificateEnvelope, context)
            .getValue();
        return this;
    }

    ManagedCertificateImpl(ManagedCertificateInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.managedCertificateName
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedCertificates");
    }

    public ManagedCertificate refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedCertificates()
            .getWithResponse(resourceGroupName, environmentName, managedCertificateName, Context.NONE)
            .getValue();
        return this;
    }

    public ManagedCertificate refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedCertificates()
            .getWithResponse(resourceGroupName, environmentName, managedCertificateName, context)
            .getValue();
        return this;
    }

    public ManagedCertificateImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public ManagedCertificateImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public ManagedCertificateImpl withTags(Map<String, String> tags) {
        if (isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        } else {
            this.updateManagedCertificateEnvelope.withTags(tags);
            return this;
        }
    }

    public ManagedCertificateImpl withProperties(ManagedCertificateProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
