// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsInner;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ManagedEnvironmentDiagnosticsClient.
 */
public final class ManagedEnvironmentDiagnosticsClientImpl implements ManagedEnvironmentDiagnosticsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ManagedEnvironmentDiagnosticsService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerAppsApiClientImpl client;

    /**
     * Initializes an instance of ManagedEnvironmentDiagnosticsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ManagedEnvironmentDiagnosticsClientImpl(ContainerAppsApiClientImpl client) {
        this.service = RestProxy.create(ManagedEnvironmentDiagnosticsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerAppsApiClientManagedEnvironmentDiagnostics to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerAppsApiClie")
    public interface ManagedEnvironmentDiagnosticsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/detectors")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticsCollectionInner>> listDetectors(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("environmentName") String environmentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/detectors/{detectorName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<DiagnosticsInner>> getDetector(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("environmentName") String environmentName, @PathParam("detectorName") String detectorName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get the list of diagnostics for a given Managed Environment.
     * 
     * Get the list of diagnostics for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Managed Environment used to host container apps along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticsCollectionInner>> listDetectorsWithResponseAsync(String resourceGroupName,
        String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listDetectors(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, environmentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the list of diagnostics for a given Managed Environment.
     * 
     * Get the list of diagnostics for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Managed Environment used to host container apps along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticsCollectionInner>> listDetectorsWithResponseAsync(String resourceGroupName,
        String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listDetectors(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            environmentName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the list of diagnostics for a given Managed Environment.
     * 
     * Get the list of diagnostics for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Managed Environment used to host container apps on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DiagnosticsCollectionInner> listDetectorsAsync(String resourceGroupName, String environmentName) {
        return listDetectorsWithResponseAsync(resourceGroupName, environmentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the list of diagnostics for a given Managed Environment.
     * 
     * Get the list of diagnostics for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Managed Environment used to host container apps along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticsCollectionInner> listDetectorsWithResponse(String resourceGroupName,
        String environmentName, Context context) {
        return listDetectorsWithResponseAsync(resourceGroupName, environmentName, context).block();
    }

    /**
     * Get the list of diagnostics for a given Managed Environment.
     * 
     * Get the list of diagnostics for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of diagnostics for a Managed Environment used to host container apps.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticsCollectionInner listDetectors(String resourceGroupName, String environmentName) {
        return listDetectorsWithResponse(resourceGroupName, environmentName, Context.NONE).getValue();
    }

    /**
     * Get the diagnostics data for a given Managed Environment.
     * 
     * Get the diagnostics data for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @param detectorName Name of the Managed Environment detector.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Managed Environment used to host container apps along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticsInner>> getDetectorWithResponseAsync(String resourceGroupName,
        String environmentName, String detectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDetector(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, environmentName, detectorName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the diagnostics data for a given Managed Environment.
     * 
     * Get the diagnostics data for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @param detectorName Name of the Managed Environment detector.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Managed Environment used to host container apps along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DiagnosticsInner>> getDetectorWithResponseAsync(String resourceGroupName,
        String environmentName, String detectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (detectorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter detectorName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDetector(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            environmentName, detectorName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the diagnostics data for a given Managed Environment.
     * 
     * Get the diagnostics data for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @param detectorName Name of the Managed Environment detector.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Managed Environment used to host container apps on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DiagnosticsInner> getDetectorAsync(String resourceGroupName, String environmentName,
        String detectorName) {
        return getDetectorWithResponseAsync(resourceGroupName, environmentName, detectorName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the diagnostics data for a given Managed Environment.
     * 
     * Get the diagnostics data for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @param detectorName Name of the Managed Environment detector.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Managed Environment used to host container apps along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DiagnosticsInner> getDetectorWithResponse(String resourceGroupName, String environmentName,
        String detectorName, Context context) {
        return getDetectorWithResponseAsync(resourceGroupName, environmentName, detectorName, context).block();
    }

    /**
     * Get the diagnostics data for a given Managed Environment.
     * 
     * Get the diagnostics data for a Managed Environment used to host container apps.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Environment.
     * @param detectorName Name of the Managed Environment detector.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the diagnostics data for a Managed Environment used to host container apps.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DiagnosticsInner getDetector(String resourceGroupName, String environmentName, String detectorName) {
        return getDetectorWithResponse(resourceGroupName, environmentName, detectorName, Context.NONE).getValue();
    }
}
