// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentDiagnosticsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.DiagnosticsInner;
import com.azure.resourcemanager.appcontainers.models.Diagnostics;
import com.azure.resourcemanager.appcontainers.models.DiagnosticsCollection;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentDiagnostics;

public final class ManagedEnvironmentDiagnosticsImpl implements ManagedEnvironmentDiagnostics {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentDiagnosticsImpl.class);

    private final ManagedEnvironmentDiagnosticsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentDiagnosticsImpl(ManagedEnvironmentDiagnosticsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<DiagnosticsCollection> listDetectorsWithResponse(String resourceGroupName, String environmentName,
        Context context) {
        Response<DiagnosticsCollectionInner> inner
            = this.serviceClient().listDetectorsWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new DiagnosticsCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public DiagnosticsCollection listDetectors(String resourceGroupName, String environmentName) {
        DiagnosticsCollectionInner inner = this.serviceClient().listDetectors(resourceGroupName, environmentName);
        if (inner != null) {
            return new DiagnosticsCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Diagnostics> getDetectorWithResponse(String resourceGroupName, String environmentName,
        String detectorName, Context context) {
        Response<DiagnosticsInner> inner
            = this.serviceClient().getDetectorWithResponse(resourceGroupName, environmentName, detectorName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new DiagnosticsImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Diagnostics getDetector(String resourceGroupName, String environmentName, String detectorName) {
        DiagnosticsInner inner = this.serviceClient().getDetector(resourceGroupName, environmentName, detectorName);
        if (inner != null) {
            return new DiagnosticsImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ManagedEnvironmentDiagnosticsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
