// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentPrivateLinkResourcesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPrivateLinkResources;
import com.azure.resourcemanager.appcontainers.models.PrivateLinkResource;

public final class ManagedEnvironmentPrivateLinkResourcesImpl implements ManagedEnvironmentPrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentPrivateLinkResourcesImpl.class);

    private final ManagedEnvironmentPrivateLinkResourcesClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentPrivateLinkResourcesImpl(ManagedEnvironmentPrivateLinkResourcesClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String environmentName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner
            = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl(inner1, this.manager()));
    }

    private ManagedEnvironmentPrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
