// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentStorage;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentStorageProperties;

public final class ManagedEnvironmentStorageImpl
    implements ManagedEnvironmentStorage, ManagedEnvironmentStorage.Definition, ManagedEnvironmentStorage.Update {
    private ManagedEnvironmentStorageInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public ManagedEnvironmentStorageProperties properties() {
        return this.innerModel().properties();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ManagedEnvironmentStorageInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String environmentName;

    private String storageName;

    public ManagedEnvironmentStorageImpl withExistingManagedEnvironment(String resourceGroupName,
        String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    public ManagedEnvironmentStorage create() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentsStorages()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, storageName, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ManagedEnvironmentStorage create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentsStorages()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, storageName, this.innerModel(), context)
            .getValue();
        return this;
    }

    ManagedEnvironmentStorageImpl(String name,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new ManagedEnvironmentStorageInner();
        this.serviceManager = serviceManager;
        this.storageName = name;
    }

    public ManagedEnvironmentStorageImpl update() {
        return this;
    }

    public ManagedEnvironmentStorage apply() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentsStorages()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, storageName, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ManagedEnvironmentStorage apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentsStorages()
            .createOrUpdateWithResponse(resourceGroupName, environmentName, storageName, this.innerModel(), context)
            .getValue();
        return this;
    }

    ManagedEnvironmentStorageImpl(ManagedEnvironmentStorageInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.storageName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "storages");
    }

    public ManagedEnvironmentStorage refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentsStorages()
            .getWithResponse(resourceGroupName, environmentName, storageName, Context.NONE)
            .getValue();
        return this;
    }

    public ManagedEnvironmentStorage refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentsStorages()
            .getWithResponse(resourceGroupName, environmentName, storageName, context)
            .getValue();
        return this;
    }

    public ManagedEnvironmentStorageImpl withProperties(ManagedEnvironmentStorageProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}
