// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsClient;
import com.azure.resourcemanager.appcontainers.fluent.models.EnvironmentAuthTokenInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentInner;
import com.azure.resourcemanager.appcontainers.fluent.models.WorkloadProfileStatesInner;
import com.azure.resourcemanager.appcontainers.models.EnvironmentAuthToken;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironment;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironments;
import com.azure.resourcemanager.appcontainers.models.WorkloadProfileStates;

public final class ManagedEnvironmentsImpl implements ManagedEnvironments {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentsImpl.class);

    private final ManagedEnvironmentsClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentsImpl(ManagedEnvironmentsClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ManagedEnvironment> list() {
        PagedIterable<ManagedEnvironmentInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedEnvironmentImpl(inner1, this.manager()));
    }

    public PagedIterable<ManagedEnvironment> list(Context context) {
        PagedIterable<ManagedEnvironmentInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedEnvironmentImpl(inner1, this.manager()));
    }

    public PagedIterable<ManagedEnvironment> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ManagedEnvironmentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedEnvironmentImpl(inner1, this.manager()));
    }

    public PagedIterable<ManagedEnvironment> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ManagedEnvironmentInner> inner
            = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedEnvironmentImpl(inner1, this.manager()));
    }

    public Response<ManagedEnvironment> getByResourceGroupWithResponse(String resourceGroupName, String environmentName,
        Context context) {
        Response<ManagedEnvironmentInner> inner
            = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ManagedEnvironmentImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ManagedEnvironment getByResourceGroup(String resourceGroupName, String environmentName) {
        ManagedEnvironmentInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, environmentName);
        if (inner != null) {
            return new ManagedEnvironmentImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void deleteByResourceGroup(String resourceGroupName, String environmentName) {
        this.serviceClient().delete(resourceGroupName, environmentName);
    }

    public void delete(String resourceGroupName, String environmentName, Context context) {
        this.serviceClient().delete(resourceGroupName, environmentName, context);
    }

    public Response<EnvironmentAuthToken> getAuthTokenWithResponse(String resourceGroupName, String environmentName,
        Context context) {
        Response<EnvironmentAuthTokenInner> inner
            = this.serviceClient().getAuthTokenWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new EnvironmentAuthTokenImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public EnvironmentAuthToken getAuthToken(String resourceGroupName, String environmentName) {
        EnvironmentAuthTokenInner inner = this.serviceClient().getAuthToken(resourceGroupName, environmentName);
        if (inner != null) {
            return new EnvironmentAuthTokenImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<WorkloadProfileStates> listWorkloadProfileStates(String resourceGroupName,
        String environmentName) {
        PagedIterable<WorkloadProfileStatesInner> inner
            = this.serviceClient().listWorkloadProfileStates(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkloadProfileStatesImpl(inner1, this.manager()));
    }

    public PagedIterable<WorkloadProfileStates> listWorkloadProfileStates(String resourceGroupName,
        String environmentName, Context context) {
        PagedIterable<WorkloadProfileStatesInner> inner
            = this.serviceClient().listWorkloadProfileStates(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkloadProfileStatesImpl(inner1, this.manager()));
    }

    public ManagedEnvironment getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, environmentName, Context.NONE).getValue();
    }

    public Response<ManagedEnvironment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, environmentName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        this.delete(resourceGroupName, environmentName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        this.delete(resourceGroupName, environmentName, context);
    }

    private ManagedEnvironmentsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public ManagedEnvironmentImpl define(String name) {
        return new ManagedEnvironmentImpl(name, this.manager());
    }
}
