// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ManagedEnvironmentStoragesCollectionInner;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentsStorages;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentStorage;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentStoragesCollection;

public final class ManagedEnvironmentsStoragesImpl implements ManagedEnvironmentsStorages {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentsStoragesImpl.class);

    private final ManagedEnvironmentsStoragesClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentsStoragesImpl(ManagedEnvironmentsStoragesClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ManagedEnvironmentStoragesCollection> listWithResponse(String resourceGroupName,
        String environmentName, Context context) {
        Response<ManagedEnvironmentStoragesCollectionInner> inner
            = this.serviceClient().listWithResponse(resourceGroupName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ManagedEnvironmentStoragesCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ManagedEnvironmentStoragesCollection list(String resourceGroupName, String environmentName) {
        ManagedEnvironmentStoragesCollectionInner inner = this.serviceClient().list(resourceGroupName, environmentName);
        if (inner != null) {
            return new ManagedEnvironmentStoragesCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ManagedEnvironmentStorage> getWithResponse(String resourceGroupName, String environmentName,
        String storageName, Context context) {
        Response<ManagedEnvironmentStorageInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, environmentName, storageName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ManagedEnvironmentStorageImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ManagedEnvironmentStorage get(String resourceGroupName, String environmentName, String storageName) {
        ManagedEnvironmentStorageInner inner
            = this.serviceClient().get(resourceGroupName, environmentName, storageName);
        if (inner != null) {
            return new ManagedEnvironmentStorageImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String storageName,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, environmentName, storageName, context);
    }

    public void delete(String resourceGroupName, String environmentName, String storageName) {
        this.serviceClient().delete(resourceGroupName, environmentName, storageName);
    }

    public ManagedEnvironmentStorage getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String storageName = ResourceManagerUtils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, storageName, Context.NONE).getValue();
    }

    public Response<ManagedEnvironmentStorage> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String storageName = ResourceManagerUtils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return this.getWithResponse(resourceGroupName, environmentName, storageName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String storageName = ResourceManagerUtils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, environmentName, storageName, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "managedEnvironments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'managedEnvironments'.", id)));
        }
        String storageName = ResourceManagerUtils.getValueFromIdByName(id, "storages");
        if (storageName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'storages'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, environmentName, storageName, context);
    }

    private ManagedEnvironmentsStoragesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    public ManagedEnvironmentStorageImpl define(String name) {
        return new ManagedEnvironmentStorageImpl(name, this.manager());
    }
}
