// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.appcontainers.models.PrivateEndpoint;
import com.azure.resourcemanager.appcontainers.models.PrivateEndpointConnection;
import com.azure.resourcemanager.appcontainers.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.appcontainers.models.PrivateLinkServiceConnectionState;
import java.util.Collections;
import java.util.List;

public final class PrivateEndpointConnectionImpl
    implements PrivateEndpointConnection, PrivateEndpointConnection.Definition, PrivateEndpointConnection.Update {
    private PrivateEndpointConnectionInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public List<String> groupIds() {
        List<String> inner = this.innerModel().groupIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public PrivateEndpoint privateEndpoint() {
        return this.innerModel().privateEndpoint();
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerModel().privateLinkServiceConnectionState();
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public PrivateEndpointConnectionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String environmentName;

    private String privateEndpointConnectionName;

    public PrivateEndpointConnectionImpl withExistingManagedEnvironment(String resourceGroupName,
        String environmentName) {
        this.resourceGroupName = resourceGroupName;
        this.environmentName = environmentName;
        return this;
    }

    public PrivateEndpointConnection create() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentPrivateEndpointConnections()
            .createOrUpdate(resourceGroupName, environmentName, privateEndpointConnectionName, this.innerModel(),
                Context.NONE);
        return this;
    }

    public PrivateEndpointConnection create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentPrivateEndpointConnections()
            .createOrUpdate(resourceGroupName, environmentName, privateEndpointConnectionName, this.innerModel(),
                context);
        return this;
    }

    PrivateEndpointConnectionImpl(String name,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionInner();
        this.serviceManager = serviceManager;
        this.privateEndpointConnectionName = name;
    }

    public PrivateEndpointConnectionImpl update() {
        return this;
    }

    public PrivateEndpointConnection apply() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentPrivateEndpointConnections()
            .createOrUpdate(resourceGroupName, environmentName, privateEndpointConnectionName, this.innerModel(),
                Context.NONE);
        return this;
    }

    public PrivateEndpointConnection apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentPrivateEndpointConnections()
            .createOrUpdate(resourceGroupName, environmentName, privateEndpointConnectionName, this.innerModel(),
                context);
        return this;
    }

    PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedEnvironments");
        this.privateEndpointConnectionName
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "privateEndpointConnections");
    }

    public PrivateEndpointConnection refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentPrivateEndpointConnections()
            .getWithResponse(resourceGroupName, environmentName, privateEndpointConnectionName, Context.NONE)
            .getValue();
        return this;
    }

    public PrivateEndpointConnection refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getManagedEnvironmentPrivateEndpointConnections()
            .getWithResponse(resourceGroupName, environmentName, privateEndpointConnectionName, context)
            .getValue();
        return this;
    }

    public PrivateEndpointConnectionImpl withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        this.innerModel().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    public PrivateEndpointConnectionImpl
        withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.innerModel().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }
}
