// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.resourcemanager.appcontainers.fluent.models.ReplicaCollectionInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ReplicaInner;
import com.azure.resourcemanager.appcontainers.models.Replica;
import com.azure.resourcemanager.appcontainers.models.ReplicaCollection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ReplicaCollectionImpl implements ReplicaCollection {
    private ReplicaCollectionInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    ReplicaCollectionImpl(ReplicaCollectionInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public List<Replica> value() {
        List<ReplicaInner> inner = this.innerModel().value();
        if (inner != null) {
            return Collections.unmodifiableList(
                inner.stream().map(inner1 -> new ReplicaImpl(inner1, this.manager())).collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public ReplicaCollectionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
