// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.ReplicaInner;
import com.azure.resourcemanager.appcontainers.models.ContainerAppReplicaRunningState;
import com.azure.resourcemanager.appcontainers.models.Replica;
import com.azure.resourcemanager.appcontainers.models.ReplicaContainer;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;

public final class ReplicaImpl implements Replica {
    private ReplicaInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    ReplicaImpl(ReplicaInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public OffsetDateTime createdTime() {
        return this.innerModel().createdTime();
    }

    public ContainerAppReplicaRunningState runningState() {
        return this.innerModel().runningState();
    }

    public String runningStateDetails() {
        return this.innerModel().runningStateDetails();
    }

    public List<ReplicaContainer> containers() {
        List<ReplicaContainer> inner = this.innerModel().containers();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<ReplicaContainer> initContainers() {
        List<ReplicaContainer> inner = this.innerModel().initContainers();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public ReplicaInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
