// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.appcontainers.fluent.models.JobExecutionInner;
import com.azure.resourcemanager.appcontainers.models.JobExecution;
import com.azure.resourcemanager.appcontainers.models.ResourceProviders;

public final class ResourceProvidersImpl implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);

    private final ResourceProvidersClient innerClient;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<JobExecution> jobExecutionWithResponse(String resourceGroupName, String jobName,
        String jobExecutionName, Context context) {
        Response<JobExecutionInner> inner
            = this.serviceClient().jobExecutionWithResponse(resourceGroupName, jobName, jobExecutionName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new JobExecutionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public JobExecution jobExecution(String resourceGroupName, String jobName, String jobExecutionName) {
        JobExecutionInner inner = this.serviceClient().jobExecution(resourceGroupName, jobName, jobExecutionName);
        if (inner != null) {
            return new JobExecutionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<String> getCustomDomainVerificationIdWithResponse(Context context) {
        return this.serviceClient().getCustomDomainVerificationIdWithResponse(context);
    }

    public String getCustomDomainVerificationId() {
        return this.serviceClient().getCustomDomainVerificationId();
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}
