// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner;
import com.azure.resourcemanager.appcontainers.models.ContainerType;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.PoolManagementType;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPool;
import com.azure.resourcemanager.appcontainers.models.SessionPoolProvisioningState;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import com.azure.resourcemanager.appcontainers.models.SessionPoolUpdatableProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SessionPoolImpl implements SessionPool, SessionPool.Definition, SessionPool.Update {
    private SessionPoolInner innerObject;

    private final com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String environmentId() {
        return this.innerModel().environmentId();
    }

    public ContainerType containerType() {
        return this.innerModel().containerType();
    }

    public PoolManagementType poolManagementType() {
        return this.innerModel().poolManagementType();
    }

    public Integer nodeCount() {
        return this.innerModel().nodeCount();
    }

    public ScaleConfiguration scaleConfiguration() {
        return this.innerModel().scaleConfiguration();
    }

    public List<SessionPoolSecret> secrets() {
        List<SessionPoolSecret> inner = this.innerModel().secrets();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.innerModel().dynamicPoolConfiguration();
    }

    public CustomContainerTemplate customContainerTemplate() {
        return this.innerModel().customContainerTemplate();
    }

    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.innerModel().sessionNetworkConfiguration();
    }

    public String poolManagementEndpoint() {
        return this.innerModel().poolManagementEndpoint();
    }

    public SessionPoolProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public SessionPoolInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.appcontainers.ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String sessionPoolName;

    private SessionPoolUpdatableProperties updateSessionPoolEnvelope;

    public SessionPoolImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public SessionPool create() {
        this.innerObject = serviceManager.serviceClient()
            .getContainerAppsSessionPools()
            .createOrUpdate(resourceGroupName, sessionPoolName, this.innerModel(), Context.NONE);
        return this;
    }

    public SessionPool create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getContainerAppsSessionPools()
            .createOrUpdate(resourceGroupName, sessionPoolName, this.innerModel(), context);
        return this;
    }

    SessionPoolImpl(String name, com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = new SessionPoolInner();
        this.serviceManager = serviceManager;
        this.sessionPoolName = name;
    }

    public SessionPoolImpl update() {
        this.updateSessionPoolEnvelope = new SessionPoolUpdatableProperties();
        return this;
    }

    public SessionPool apply() {
        this.innerObject = serviceManager.serviceClient()
            .getContainerAppsSessionPools()
            .update(resourceGroupName, sessionPoolName, updateSessionPoolEnvelope, Context.NONE);
        return this;
    }

    public SessionPool apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getContainerAppsSessionPools()
            .update(resourceGroupName, sessionPoolName, updateSessionPoolEnvelope, context);
        return this;
    }

    SessionPoolImpl(SessionPoolInner innerObject,
        com.azure.resourcemanager.appcontainers.ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sessionPoolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sessionPools");
    }

    public SessionPool refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getContainerAppsSessionPools()
            .getByResourceGroupWithResponse(resourceGroupName, sessionPoolName, Context.NONE)
            .getValue();
        return this;
    }

    public SessionPool refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getContainerAppsSessionPools()
            .getByResourceGroupWithResponse(resourceGroupName, sessionPoolName, context)
            .getValue();
        return this;
    }

    public SessionPoolImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public SessionPoolImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public SessionPoolImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    public SessionPoolImpl withEnvironmentId(String environmentId) {
        this.innerModel().withEnvironmentId(environmentId);
        return this;
    }

    public SessionPoolImpl withContainerType(ContainerType containerType) {
        this.innerModel().withContainerType(containerType);
        return this;
    }

    public SessionPoolImpl withPoolManagementType(PoolManagementType poolManagementType) {
        this.innerModel().withPoolManagementType(poolManagementType);
        return this;
    }

    public SessionPoolImpl withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        if (isInCreateMode()) {
            this.innerModel().withScaleConfiguration(scaleConfiguration);
            return this;
        } else {
            this.updateSessionPoolEnvelope.withScaleConfiguration(scaleConfiguration);
            return this;
        }
    }

    public SessionPoolImpl withSecrets(List<SessionPoolSecret> secrets) {
        if (isInCreateMode()) {
            this.innerModel().withSecrets(secrets);
            return this;
        } else {
            this.updateSessionPoolEnvelope.withSecrets(secrets);
            return this;
        }
    }

    public SessionPoolImpl withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        if (isInCreateMode()) {
            this.innerModel().withDynamicPoolConfiguration(dynamicPoolConfiguration);
            return this;
        } else {
            this.updateSessionPoolEnvelope.withDynamicPoolConfiguration(dynamicPoolConfiguration);
            return this;
        }
    }

    public SessionPoolImpl withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        if (isInCreateMode()) {
            this.innerModel().withCustomContainerTemplate(customContainerTemplate);
            return this;
        } else {
            this.updateSessionPoolEnvelope.withCustomContainerTemplate(customContainerTemplate);
            return this;
        }
    }

    public SessionPoolImpl withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        if (isInCreateMode()) {
            this.innerModel().withSessionNetworkConfiguration(sessionNetworkConfiguration);
            return this;
        } else {
            this.updateSessionPoolEnvelope.withSessionNetworkConfiguration(sessionNetworkConfiguration);
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
