// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration of Application Insights.
 */
@Fluent
public final class AppInsightsConfiguration implements JsonSerializable<AppInsightsConfiguration> {
    /*
     * Application Insights connection string
     */
    private String connectionString;

    /**
     * Creates an instance of AppInsightsConfiguration class.
     */
    public AppInsightsConfiguration() {
    }

    /**
     * Get the connectionString property: Application Insights connection string.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Application Insights connection string.
     * 
     * @param connectionString the connectionString value to set.
     * @return the AppInsightsConfiguration object itself.
     */
    public AppInsightsConfiguration withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppInsightsConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppInsightsConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AppInsightsConfiguration.
     */
    public static AppInsightsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppInsightsConfiguration deserializedAppInsightsConfiguration = new AppInsightsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionString".equals(fieldName)) {
                    deserializedAppInsightsConfiguration.connectionString = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppInsightsConfiguration;
        });
    }
}
