// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http.
 */
public final class AppProtocol extends ExpandableStringEnum<AppProtocol> {
    /**
     * Static value http for AppProtocol.
     */
    public static final AppProtocol HTTP = fromString("http");

    /**
     * Static value grpc for AppProtocol.
     */
    public static final AppProtocol GRPC = fromString("grpc");

    /**
     * Creates a new instance of AppProtocol value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AppProtocol() {
    }

    /**
     * Creates or finds a AppProtocol from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AppProtocol.
     */
    public static AppProtocol fromString(String name) {
        return fromString(name, AppProtocol.class);
    }

    /**
     * Gets known AppProtocol values.
     * 
     * @return known AppProtocol values.
     */
    public static Collection<AppProtocol> values() {
        return values(AppProtocol.class);
    }
}
