// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of AppResiliencies.
 */
public interface AppResiliencies {
    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String resourceGroupName, String appName, String name, Context context);

    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String appName, String name);

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy along with {@link Response}.
     */
    Response<AppResiliency> getWithResponse(String resourceGroupName, String appName, String name, Context context);

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param name Name of the resiliency policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy.
     */
    AppResiliency get(String resourceGroupName, String appName, String name);

    /**
     * List an application's resiliency policies.
     * 
     * List container app resiliency policies.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies as paginated response with {@link PagedIterable}.
     */
    PagedIterable<AppResiliency> list(String resourceGroupName, String appName);

    /**
     * List an application's resiliency policies.
     * 
     * List container app resiliency policies.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param appName Name of the Container App.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of AppResiliency policies as paginated response with {@link PagedIterable}.
     */
    PagedIterable<AppResiliency> list(String resourceGroupName, String appName, Context context);

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy along with {@link Response}.
     */
    AppResiliency getById(String id);

    /**
     * Get an application's resiliency policy.
     * 
     * Get container app resiliency policy.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container app resiliency policy along with {@link Response}.
     */
    Response<AppResiliency> getByIdWithResponse(String id, Context context);

    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Delete an application's resiliency policy.
     * 
     * Delete container app resiliency policy.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new AppResiliency resource.
     * 
     * @param name resource name.
     * @return the first stage of the new AppResiliency definition.
     */
    AppResiliency.DefinitionStages.Blank define(String name);
}
