// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner;

/**
 * An immutable client-side representation of AppResiliency.
 */
public interface AppResiliency {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the timeoutPolicy property: Policy to set request timeouts.
     * 
     * @return the timeoutPolicy value.
     */
    TimeoutPolicy timeoutPolicy();

    /**
     * Gets the httpRetryPolicy property: Policy that defines http request retry conditions.
     * 
     * @return the httpRetryPolicy value.
     */
    HttpRetryPolicy httpRetryPolicy();

    /**
     * Gets the tcpRetryPolicy property: Policy that defines tcp request retry conditions.
     * 
     * @return the tcpRetryPolicy value.
     */
    TcpRetryPolicy tcpRetryPolicy();

    /**
     * Gets the circuitBreakerPolicy property: Policy that defines circuit breaker conditions.
     * 
     * @return the circuitBreakerPolicy value.
     */
    CircuitBreakerPolicy circuitBreakerPolicy();

    /**
     * Gets the httpConnectionPool property: Defines parameters for http connection pooling.
     * 
     * @return the httpConnectionPool value.
     */
    HttpConnectionPool httpConnectionPool();

    /**
     * Gets the tcpConnectionPool property: Defines parameters for tcp connection pooling.
     * 
     * @return the tcpConnectionPool value.
     */
    TcpConnectionPool tcpConnectionPool();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.AppResiliencyInner object.
     * 
     * @return the inner object.
     */
    AppResiliencyInner innerModel();

    /**
     * The entirety of the AppResiliency definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The AppResiliency definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the AppResiliency definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the AppResiliency definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, appName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param appName Name of the Container App.
             * @return the next definition stage.
             */
            WithCreate withExistingContainerApp(String resourceGroupName, String appName);
        }

        /**
         * The stage of the AppResiliency definition which contains all the minimum required properties for the resource
         * to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithTimeoutPolicy, DefinitionStages.WithHttpRetryPolicy,
            DefinitionStages.WithTcpRetryPolicy, DefinitionStages.WithCircuitBreakerPolicy,
            DefinitionStages.WithHttpConnectionPool, DefinitionStages.WithTcpConnectionPool {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            AppResiliency create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            AppResiliency create(Context context);
        }

        /**
         * The stage of the AppResiliency definition allowing to specify timeoutPolicy.
         */
        interface WithTimeoutPolicy {
            /**
             * Specifies the timeoutPolicy property: Policy to set request timeouts.
             * 
             * @param timeoutPolicy Policy to set request timeouts.
             * @return the next definition stage.
             */
            WithCreate withTimeoutPolicy(TimeoutPolicy timeoutPolicy);
        }

        /**
         * The stage of the AppResiliency definition allowing to specify httpRetryPolicy.
         */
        interface WithHttpRetryPolicy {
            /**
             * Specifies the httpRetryPolicy property: Policy that defines http request retry conditions.
             * 
             * @param httpRetryPolicy Policy that defines http request retry conditions.
             * @return the next definition stage.
             */
            WithCreate withHttpRetryPolicy(HttpRetryPolicy httpRetryPolicy);
        }

        /**
         * The stage of the AppResiliency definition allowing to specify tcpRetryPolicy.
         */
        interface WithTcpRetryPolicy {
            /**
             * Specifies the tcpRetryPolicy property: Policy that defines tcp request retry conditions.
             * 
             * @param tcpRetryPolicy Policy that defines tcp request retry conditions.
             * @return the next definition stage.
             */
            WithCreate withTcpRetryPolicy(TcpRetryPolicy tcpRetryPolicy);
        }

        /**
         * The stage of the AppResiliency definition allowing to specify circuitBreakerPolicy.
         */
        interface WithCircuitBreakerPolicy {
            /**
             * Specifies the circuitBreakerPolicy property: Policy that defines circuit breaker conditions.
             * 
             * @param circuitBreakerPolicy Policy that defines circuit breaker conditions.
             * @return the next definition stage.
             */
            WithCreate withCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy);
        }

        /**
         * The stage of the AppResiliency definition allowing to specify httpConnectionPool.
         */
        interface WithHttpConnectionPool {
            /**
             * Specifies the httpConnectionPool property: Defines parameters for http connection pooling.
             * 
             * @param httpConnectionPool Defines parameters for http connection pooling.
             * @return the next definition stage.
             */
            WithCreate withHttpConnectionPool(HttpConnectionPool httpConnectionPool);
        }

        /**
         * The stage of the AppResiliency definition allowing to specify tcpConnectionPool.
         */
        interface WithTcpConnectionPool {
            /**
             * Specifies the tcpConnectionPool property: Defines parameters for tcp connection pooling.
             * 
             * @param tcpConnectionPool Defines parameters for tcp connection pooling.
             * @return the next definition stage.
             */
            WithCreate withTcpConnectionPool(TcpConnectionPool tcpConnectionPool);
        }
    }

    /**
     * Begins update for the AppResiliency resource.
     * 
     * @return the stage of resource update.
     */
    AppResiliency.Update update();

    /**
     * The template for AppResiliency update.
     */
    interface Update
        extends UpdateStages.WithTimeoutPolicy, UpdateStages.WithHttpRetryPolicy, UpdateStages.WithTcpRetryPolicy,
        UpdateStages.WithCircuitBreakerPolicy, UpdateStages.WithHttpConnectionPool, UpdateStages.WithTcpConnectionPool {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        AppResiliency apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        AppResiliency apply(Context context);
    }

    /**
     * The AppResiliency update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the AppResiliency update allowing to specify timeoutPolicy.
         */
        interface WithTimeoutPolicy {
            /**
             * Specifies the timeoutPolicy property: Policy to set request timeouts.
             * 
             * @param timeoutPolicy Policy to set request timeouts.
             * @return the next definition stage.
             */
            Update withTimeoutPolicy(TimeoutPolicy timeoutPolicy);
        }

        /**
         * The stage of the AppResiliency update allowing to specify httpRetryPolicy.
         */
        interface WithHttpRetryPolicy {
            /**
             * Specifies the httpRetryPolicy property: Policy that defines http request retry conditions.
             * 
             * @param httpRetryPolicy Policy that defines http request retry conditions.
             * @return the next definition stage.
             */
            Update withHttpRetryPolicy(HttpRetryPolicy httpRetryPolicy);
        }

        /**
         * The stage of the AppResiliency update allowing to specify tcpRetryPolicy.
         */
        interface WithTcpRetryPolicy {
            /**
             * Specifies the tcpRetryPolicy property: Policy that defines tcp request retry conditions.
             * 
             * @param tcpRetryPolicy Policy that defines tcp request retry conditions.
             * @return the next definition stage.
             */
            Update withTcpRetryPolicy(TcpRetryPolicy tcpRetryPolicy);
        }

        /**
         * The stage of the AppResiliency update allowing to specify circuitBreakerPolicy.
         */
        interface WithCircuitBreakerPolicy {
            /**
             * Specifies the circuitBreakerPolicy property: Policy that defines circuit breaker conditions.
             * 
             * @param circuitBreakerPolicy Policy that defines circuit breaker conditions.
             * @return the next definition stage.
             */
            Update withCircuitBreakerPolicy(CircuitBreakerPolicy circuitBreakerPolicy);
        }

        /**
         * The stage of the AppResiliency update allowing to specify httpConnectionPool.
         */
        interface WithHttpConnectionPool {
            /**
             * Specifies the httpConnectionPool property: Defines parameters for http connection pooling.
             * 
             * @param httpConnectionPool Defines parameters for http connection pooling.
             * @return the next definition stage.
             */
            Update withHttpConnectionPool(HttpConnectionPool httpConnectionPool);
        }

        /**
         * The stage of the AppResiliency update allowing to specify tcpConnectionPool.
         */
        interface WithTcpConnectionPool {
            /**
             * Specifies the tcpConnectionPool property: Defines parameters for tcp connection pooling.
             * 
             * @param tcpConnectionPool Defines parameters for tcp connection pooling.
             * @return the next definition stage.
             */
            Update withTcpConnectionPool(TcpConnectionPool tcpConnectionPool);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    AppResiliency refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    AppResiliency refresh(Context context);
}
