// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * indicates whether the profile is default for the location.
 */
public final class Applicability extends ExpandableStringEnum<Applicability> {
    /**
     * Static value LocationDefault for Applicability.
     */
    public static final Applicability LOCATION_DEFAULT = fromString("LocationDefault");

    /**
     * Static value Custom for Applicability.
     */
    public static final Applicability CUSTOM = fromString("Custom");

    /**
     * Creates a new instance of Applicability value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Applicability() {
    }

    /**
     * Creates or finds a Applicability from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Applicability.
     */
    public static Applicability fromString(String name) {
        return fromString(name, Applicability.class);
    }

    /**
     * Gets known Applicability values.
     * 
     * @return known Applicability values.
     */
    public static Collection<Applicability> values() {
        return values(Applicability.class);
    }
}
