// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.AvailableWorkloadProfileInner;
import java.io.IOException;
import java.util.List;

/**
 * Collection of available workload profiles in the location.
 */
@Fluent
public final class AvailableWorkloadProfilesCollection
    implements JsonSerializable<AvailableWorkloadProfilesCollection> {
    /*
     * Collection of workload profiles.
     */
    private List<AvailableWorkloadProfileInner> value;

    /*
     * Link to next page of resources.
     */
    private String nextLink;

    /**
     * Creates an instance of AvailableWorkloadProfilesCollection class.
     */
    public AvailableWorkloadProfilesCollection() {
    }

    /**
     * Get the value property: Collection of workload profiles.
     * 
     * @return the value value.
     */
    public List<AvailableWorkloadProfileInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of workload profiles.
     * 
     * @param value the value value to set.
     * @return the AvailableWorkloadProfilesCollection object itself.
     */
    public AvailableWorkloadProfilesCollection withValue(List<AvailableWorkloadProfileInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model AvailableWorkloadProfilesCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AvailableWorkloadProfilesCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailableWorkloadProfilesCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailableWorkloadProfilesCollection if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AvailableWorkloadProfilesCollection.
     */
    public static AvailableWorkloadProfilesCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailableWorkloadProfilesCollection deserializedAvailableWorkloadProfilesCollection
                = new AvailableWorkloadProfilesCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AvailableWorkloadProfileInner> value
                        = reader.readArray(reader1 -> AvailableWorkloadProfileInner.fromJson(reader1));
                    deserializedAvailableWorkloadProfilesCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAvailableWorkloadProfilesCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailableWorkloadProfilesCollection;
        });
    }
}
