// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App credentials.
 */
@Fluent
public final class AzureCredentials implements JsonSerializable<AzureCredentials> {
    /*
     * Client Id.
     */
    private String clientId;

    /*
     * Client Secret.
     */
    private String clientSecret;

    /*
     * Tenant Id.
     */
    private String tenantId;

    /*
     * Kind of auth github does for deploying the template
     */
    private String kind;

    /*
     * Subscription Id.
     */
    private String subscriptionId;

    /**
     * Creates an instance of AzureCredentials class.
     */
    public AzureCredentials() {
    }

    /**
     * Get the clientId property: Client Id.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: Client Id.
     * 
     * @param clientId the clientId value to set.
     * @return the AzureCredentials object itself.
     */
    public AzureCredentials withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecret property: Client Secret.
     * 
     * @return the clientSecret value.
     */
    public String clientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: Client Secret.
     * 
     * @param clientSecret the clientSecret value to set.
     * @return the AzureCredentials object itself.
     */
    public AzureCredentials withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the tenantId property: Tenant Id.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: Tenant Id.
     * 
     * @param tenantId the tenantId value to set.
     * @return the AzureCredentials object itself.
     */
    public AzureCredentials withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the kind property: Kind of auth github does for deploying the template.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Kind of auth github does for deploying the template.
     * 
     * @param kind the kind value to set.
     * @return the AzureCredentials object itself.
     */
    public AzureCredentials withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the subscriptionId property: Subscription Id.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: Subscription Id.
     * 
     * @param subscriptionId the subscriptionId value to set.
     * @return the AzureCredentials object itself.
     */
    public AzureCredentials withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureCredentials from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureCredentials if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureCredentials.
     */
    public static AzureCredentials fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureCredentials deserializedAzureCredentials = new AzureCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientId".equals(fieldName)) {
                    deserializedAzureCredentials.clientId = reader.getString();
                } else if ("clientSecret".equals(fieldName)) {
                    deserializedAzureCredentials.clientSecret = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedAzureCredentials.tenantId = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedAzureCredentials.kind = reader.getString();
                } else if ("subscriptionId".equals(fieldName)) {
                    deserializedAzureCredentials.subscriptionId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureCredentials;
        });
    }
}
