// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure File Properties.
 */
@Fluent
public final class AzureFileProperties implements JsonSerializable<AzureFileProperties> {
    /*
     * Storage account name for azure file.
     */
    private String accountName;

    /*
     * Storage account key for azure file.
     */
    private String accountKey;

    /*
     * Access mode for storage
     */
    private AccessMode accessMode;

    /*
     * Azure file share name.
     */
    private String shareName;

    /**
     * Creates an instance of AzureFileProperties class.
     */
    public AzureFileProperties() {
    }

    /**
     * Get the accountName property: Storage account name for azure file.
     * 
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: Storage account name for azure file.
     * 
     * @param accountName the accountName value to set.
     * @return the AzureFileProperties object itself.
     */
    public AzureFileProperties withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the accountKey property: Storage account key for azure file.
     * 
     * @return the accountKey value.
     */
    public String accountKey() {
        return this.accountKey;
    }

    /**
     * Set the accountKey property: Storage account key for azure file.
     * 
     * @param accountKey the accountKey value to set.
     * @return the AzureFileProperties object itself.
     */
    public AzureFileProperties withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    /**
     * Get the accessMode property: Access mode for storage.
     * 
     * @return the accessMode value.
     */
    public AccessMode accessMode() {
        return this.accessMode;
    }

    /**
     * Set the accessMode property: Access mode for storage.
     * 
     * @param accessMode the accessMode value to set.
     * @return the AzureFileProperties object itself.
     */
    public AzureFileProperties withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    /**
     * Get the shareName property: Azure file share name.
     * 
     * @return the shareName value.
     */
    public String shareName() {
        return this.shareName;
    }

    /**
     * Set the shareName property: Azure file share name.
     * 
     * @param shareName the shareName value to set.
     * @return the AzureFileProperties object itself.
     */
    public AzureFileProperties withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        jsonWriter.writeStringField("shareName", this.shareName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFileProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFileProperties.
     */
    public static AzureFileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFileProperties deserializedAzureFileProperties = new AzureFileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountName".equals(fieldName)) {
                    deserializedAzureFileProperties.accountName = reader.getString();
                } else if ("accountKey".equals(fieldName)) {
                    deserializedAzureFileProperties.accountKey = reader.getString();
                } else if ("accessMode".equals(fieldName)) {
                    deserializedAzureFileProperties.accessMode = AccessMode.fromString(reader.getString());
                } else if ("shareName".equals(fieldName)) {
                    deserializedAzureFileProperties.shareName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFileProperties;
        });
    }
}
