// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the registration for the Azure Static Web Apps provider.
 */
@Fluent
public final class AzureStaticWebAppsRegistration implements JsonSerializable<AzureStaticWebAppsRegistration> {
    /*
     * The Client ID of the app used for login.
     */
    private String clientId;

    /**
     * Creates an instance of AzureStaticWebAppsRegistration class.
     */
    public AzureStaticWebAppsRegistration() {
    }

    /**
     * Get the clientId property: The Client ID of the app used for login.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The Client ID of the app used for login.
     * 
     * @param clientId the clientId value to set.
     * @return the AzureStaticWebAppsRegistration object itself.
     */
    public AzureStaticWebAppsRegistration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientId", this.clientId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureStaticWebAppsRegistration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureStaticWebAppsRegistration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureStaticWebAppsRegistration.
     */
    public static AzureStaticWebAppsRegistration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureStaticWebAppsRegistration deserializedAzureStaticWebAppsRegistration
                = new AzureStaticWebAppsRegistration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientId".equals(fieldName)) {
                    deserializedAzureStaticWebAppsRegistration.clientId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureStaticWebAppsRegistration;
        });
    }
}
