// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Revision resource specific properties.
 */
@Fluent
public final class BillingMeterProperties implements JsonSerializable<BillingMeterProperties> {
    /*
     * Used to categorize billing meters.
     */
    private String category;

    /*
     * Billing meter type.
     */
    private String meterType;

    /*
     * The everyday name of the billing meter.
     */
    private String displayName;

    /**
     * Creates an instance of BillingMeterProperties class.
     */
    public BillingMeterProperties() {
    }

    /**
     * Get the category property: Used to categorize billing meters.
     * 
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Set the category property: Used to categorize billing meters.
     * 
     * @param category the category value to set.
     * @return the BillingMeterProperties object itself.
     */
    public BillingMeterProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the meterType property: Billing meter type.
     * 
     * @return the meterType value.
     */
    public String meterType() {
        return this.meterType;
    }

    /**
     * Set the meterType property: Billing meter type.
     * 
     * @param meterType the meterType value to set.
     * @return the BillingMeterProperties object itself.
     */
    public BillingMeterProperties withMeterType(String meterType) {
        this.meterType = meterType;
        return this;
    }

    /**
     * Get the displayName property: The everyday name of the billing meter.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The everyday name of the billing meter.
     * 
     * @param displayName the displayName value to set.
     * @return the BillingMeterProperties object itself.
     */
    public BillingMeterProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("meterType", this.meterType);
        jsonWriter.writeStringField("displayName", this.displayName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BillingMeterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BillingMeterProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BillingMeterProperties.
     */
    public static BillingMeterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BillingMeterProperties deserializedBillingMeterProperties = new BillingMeterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("category".equals(fieldName)) {
                    deserializedBillingMeterProperties.category = reader.getString();
                } else if ("meterType".equals(fieldName)) {
                    deserializedBillingMeterProperties.meterType = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedBillingMeterProperties.displayName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBillingMeterProperties;
        });
    }
}
