// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of BuildAuthTokens.
 */
public interface BuildAuthTokens {
    /**
     * Gets the token used to connect to the endpoint where source code can be uploaded for a build.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param buildName The name of a build.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the token used to connect to the endpoint where source code can be uploaded for a build along with
     * {@link Response}.
     */
    Response<BuildToken> listWithResponse(String resourceGroupName, String builderName, String buildName,
        Context context);

    /**
     * Gets the token used to connect to the endpoint where source code can be uploaded for a build.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param builderName The name of the builder.
     * @param buildName The name of a build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the token used to connect to the endpoint where source code can be uploaded for a build.
     */
    BuildToken list(String resourceGroupName, String builderName, String buildName);
}
