// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of a BuildResource list operation.
 */
@Fluent
public final class BuildCollection implements JsonSerializable<BuildCollection> {
    /*
     * The BuildResource items on this page
     */
    private List<BuildResourceInner> value;

    /*
     * The link to the next page of items
     */
    private String nextLink;

    /**
     * Creates an instance of BuildCollection class.
     */
    public BuildCollection() {
    }

    /**
     * Get the value property: The BuildResource items on this page.
     * 
     * @return the value value.
     */
    public List<BuildResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The BuildResource items on this page.
     * 
     * @param value the value value to set.
     * @return the BuildCollection object itself.
     */
    public BuildCollection withValue(List<BuildResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to the next page of items.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to the next page of items.
     * 
     * @param nextLink the nextLink value to set.
     * @return the BuildCollection object itself.
     */
    public BuildCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model BuildCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BuildCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildCollection if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BuildCollection.
     */
    public static BuildCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildCollection deserializedBuildCollection = new BuildCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<BuildResourceInner> value = reader.readArray(reader1 -> BuildResourceInner.fromJson(reader1));
                    deserializedBuildCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedBuildCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildCollection;
        });
    }
}
