// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Configuration of the build.
 */
@Fluent
public final class BuildConfiguration implements JsonSerializable<BuildConfiguration> {
    /*
     * Base OS used to build and run the app.
     */
    private String baseOs;

    /*
     * Platform to be used to build and run the app.
     */
    private String platform;

    /*
     * Platform version to be used to build and run the app.
     */
    private String platformVersion;

    /*
     * List of environment variables to be passed to the build, secrets should not be used in environment variable.
     */
    private List<EnvironmentVariable> environmentVariables;

    /*
     * List of steps to perform before the build.
     */
    private List<PreBuildStep> preBuildSteps;

    /**
     * Creates an instance of BuildConfiguration class.
     */
    public BuildConfiguration() {
    }

    /**
     * Get the baseOs property: Base OS used to build and run the app.
     * 
     * @return the baseOs value.
     */
    public String baseOs() {
        return this.baseOs;
    }

    /**
     * Set the baseOs property: Base OS used to build and run the app.
     * 
     * @param baseOs the baseOs value to set.
     * @return the BuildConfiguration object itself.
     */
    public BuildConfiguration withBaseOs(String baseOs) {
        this.baseOs = baseOs;
        return this;
    }

    /**
     * Get the platform property: Platform to be used to build and run the app.
     * 
     * @return the platform value.
     */
    public String platform() {
        return this.platform;
    }

    /**
     * Set the platform property: Platform to be used to build and run the app.
     * 
     * @param platform the platform value to set.
     * @return the BuildConfiguration object itself.
     */
    public BuildConfiguration withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    /**
     * Get the platformVersion property: Platform version to be used to build and run the app.
     * 
     * @return the platformVersion value.
     */
    public String platformVersion() {
        return this.platformVersion;
    }

    /**
     * Set the platformVersion property: Platform version to be used to build and run the app.
     * 
     * @param platformVersion the platformVersion value to set.
     * @return the BuildConfiguration object itself.
     */
    public BuildConfiguration withPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
        return this;
    }

    /**
     * Get the environmentVariables property: List of environment variables to be passed to the build, secrets should
     * not be used in environment variable.
     * 
     * @return the environmentVariables value.
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables property: List of environment variables to be passed to the build, secrets should
     * not be used in environment variable.
     * 
     * @param environmentVariables the environmentVariables value to set.
     * @return the BuildConfiguration object itself.
     */
    public BuildConfiguration withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the preBuildSteps property: List of steps to perform before the build.
     * 
     * @return the preBuildSteps value.
     */
    public List<PreBuildStep> preBuildSteps() {
        return this.preBuildSteps;
    }

    /**
     * Set the preBuildSteps property: List of steps to perform before the build.
     * 
     * @param preBuildSteps the preBuildSteps value to set.
     * @return the BuildConfiguration object itself.
     */
    public BuildConfiguration withPreBuildSteps(List<PreBuildStep> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (environmentVariables() != null) {
            environmentVariables().forEach(e -> e.validate());
        }
        if (preBuildSteps() != null) {
            preBuildSteps().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("baseOs", this.baseOs);
        jsonWriter.writeStringField("platform", this.platform);
        jsonWriter.writeStringField("platformVersion", this.platformVersion);
        jsonWriter.writeArrayField("environmentVariables", this.environmentVariables,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("preBuildSteps", this.preBuildSteps, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildConfiguration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuildConfiguration.
     */
    public static BuildConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildConfiguration deserializedBuildConfiguration = new BuildConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseOs".equals(fieldName)) {
                    deserializedBuildConfiguration.baseOs = reader.getString();
                } else if ("platform".equals(fieldName)) {
                    deserializedBuildConfiguration.platform = reader.getString();
                } else if ("platformVersion".equals(fieldName)) {
                    deserializedBuildConfiguration.platformVersion = reader.getString();
                } else if ("environmentVariables".equals(fieldName)) {
                    List<EnvironmentVariable> environmentVariables
                        = reader.readArray(reader1 -> EnvironmentVariable.fromJson(reader1));
                    deserializedBuildConfiguration.environmentVariables = environmentVariables;
                } else if ("preBuildSteps".equals(fieldName)) {
                    List<PreBuildStep> preBuildSteps = reader.readArray(reader1 -> PreBuildStep.fromJson(reader1));
                    deserializedBuildConfiguration.preBuildSteps = preBuildSteps;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuildConfiguration;
        });
    }
}
