// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner;

/**
 * An immutable client-side representation of BuildResource.
 */
public interface BuildResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the provisioningState property: Build provisioning state.
     * 
     * @return the provisioningState value.
     */
    BuildProvisioningState provisioningState();

    /**
     * Gets the buildStatus property: Status of the build once it has been provisioned.
     * 
     * @return the buildStatus value.
     */
    BuildStatus buildStatus();

    /**
     * Gets the destinationContainerRegistry property: Container registry that the final image will be uploaded to.
     * 
     * @return the destinationContainerRegistry value.
     */
    ContainerRegistryWithCustomImage destinationContainerRegistry();

    /**
     * Gets the configuration property: Configuration of the build.
     * 
     * @return the configuration value.
     */
    BuildConfiguration configuration();

    /**
     * Gets the uploadEndpoint property: Endpoint to which the source code should be uploaded.
     * 
     * @return the uploadEndpoint value.
     */
    String uploadEndpoint();

    /**
     * Gets the logStreamEndpoint property: Endpoint from which the build logs can be streamed.
     * 
     * @return the logStreamEndpoint value.
     */
    String logStreamEndpoint();

    /**
     * Gets the tokenEndpoint property: Endpoint to use to retrieve an authentication token for log streaming and
     * uploading source code.
     * 
     * @return the tokenEndpoint value.
     */
    String tokenEndpoint();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.BuildResourceInner object.
     * 
     * @return the inner object.
     */
    BuildResourceInner innerModel();

    /**
     * The entirety of the BuildResource definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The BuildResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the BuildResource definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the BuildResource definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, builderName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param builderName The name of the builder.
             * @return the next definition stage.
             */
            WithCreate withExistingBuilder(String resourceGroupName, String builderName);
        }

        /**
         * The stage of the BuildResource definition which contains all the minimum required properties for the resource
         * to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithDestinationContainerRegistry, DefinitionStages.WithConfiguration {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            BuildResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            BuildResource create(Context context);
        }

        /**
         * The stage of the BuildResource definition allowing to specify destinationContainerRegistry.
         */
        interface WithDestinationContainerRegistry {
            /**
             * Specifies the destinationContainerRegistry property: Container registry that the final image will be
             * uploaded to..
             * 
             * @param destinationContainerRegistry Container registry that the final image will be uploaded to.
             * @return the next definition stage.
             */
            WithCreate withDestinationContainerRegistry(ContainerRegistryWithCustomImage destinationContainerRegistry);
        }

        /**
         * The stage of the BuildResource definition allowing to specify configuration.
         */
        interface WithConfiguration {
            /**
             * Specifies the configuration property: Configuration of the build..
             * 
             * @param configuration Configuration of the build.
             * @return the next definition stage.
             */
            WithCreate withConfiguration(BuildConfiguration configuration);
        }
    }

    /**
     * Begins update for the BuildResource resource.
     * 
     * @return the stage of resource update.
     */
    BuildResource.Update update();

    /**
     * The template for BuildResource update.
     */
    interface Update extends UpdateStages.WithDestinationContainerRegistry, UpdateStages.WithConfiguration {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        BuildResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        BuildResource apply(Context context);
    }

    /**
     * The BuildResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the BuildResource update allowing to specify destinationContainerRegistry.
         */
        interface WithDestinationContainerRegistry {
            /**
             * Specifies the destinationContainerRegistry property: Container registry that the final image will be
             * uploaded to..
             * 
             * @param destinationContainerRegistry Container registry that the final image will be uploaded to.
             * @return the next definition stage.
             */
            Update withDestinationContainerRegistry(ContainerRegistryWithCustomImage destinationContainerRegistry);
        }

        /**
         * The stage of the BuildResource update allowing to specify configuration.
         */
        interface WithConfiguration {
            /**
             * Specifies the configuration property: Configuration of the build..
             * 
             * @param configuration Configuration of the build.
             * @return the next definition stage.
             */
            Update withConfiguration(BuildConfiguration configuration);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    BuildResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    BuildResource refresh(Context context);
}
