// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Status of the build once it has been provisioned.
 */
public final class BuildStatus extends ExpandableStringEnum<BuildStatus> {
    /**
     * Static value NotStarted for BuildStatus.
     */
    public static final BuildStatus NOT_STARTED = fromString("NotStarted");

    /**
     * Static value InProgress for BuildStatus.
     */
    public static final BuildStatus IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Succeeded for BuildStatus.
     */
    public static final BuildStatus SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Canceled for BuildStatus.
     */
    public static final BuildStatus CANCELED = fromString("Canceled");

    /**
     * Static value Failed for BuildStatus.
     */
    public static final BuildStatus FAILED = fromString("Failed");

    /**
     * Creates a new instance of BuildStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public BuildStatus() {
    }

    /**
     * Creates or finds a BuildStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding BuildStatus.
     */
    public static BuildStatus fromString(String name) {
        return fromString(name, BuildStatus.class);
    }

    /**
     * Gets known BuildStatus values.
     * 
     * @return known BuildStatus values.
     */
    public static Collection<BuildStatus> values() {
        return values(BuildStatus.class);
    }
}
