// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of a BuilderResource list operation.
 */
@Fluent
public final class BuilderCollection implements JsonSerializable<BuilderCollection> {
    /*
     * The BuilderResource items on this page
     */
    private List<BuilderResourceInner> value;

    /*
     * The link to the next page of items
     */
    private String nextLink;

    /**
     * Creates an instance of BuilderCollection class.
     */
    public BuilderCollection() {
    }

    /**
     * Get the value property: The BuilderResource items on this page.
     * 
     * @return the value value.
     */
    public List<BuilderResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The BuilderResource items on this page.
     * 
     * @param value the value value to set.
     * @return the BuilderCollection object itself.
     */
    public BuilderCollection withValue(List<BuilderResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to the next page of items.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to the next page of items.
     * 
     * @param nextLink the nextLink value to set.
     * @return the BuilderCollection object itself.
     */
    public BuilderCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model BuilderCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BuilderCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuilderCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuilderCollection if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BuilderCollection.
     */
    public static BuilderCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuilderCollection deserializedBuilderCollection = new BuilderCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<BuilderResourceInner> value
                        = reader.readArray(reader1 -> BuilderResourceInner.fromJson(reader1));
                    deserializedBuilderCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedBuilderCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuilderCollection;
        });
    }
}
