// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Resource instance provisioning state.
 */
public final class BuilderProvisioningState extends ExpandableStringEnum<BuilderProvisioningState> {
    /**
     * Static value Succeeded for BuilderProvisioningState.
     */
    public static final BuilderProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for BuilderProvisioningState.
     */
    public static final BuilderProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Canceled for BuilderProvisioningState.
     */
    public static final BuilderProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Creating for BuilderProvisioningState.
     */
    public static final BuilderProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for BuilderProvisioningState.
     */
    public static final BuilderProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Deleting for BuilderProvisioningState.
     */
    public static final BuilderProvisioningState DELETING = fromString("Deleting");

    /**
     * Creates a new instance of BuilderProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public BuilderProvisioningState() {
    }

    /**
     * Creates or finds a BuilderProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding BuilderProvisioningState.
     */
    public static BuilderProvisioningState fromString(String name) {
        return fromString(name, BuilderProvisioningState.class);
    }

    /**
     * Gets known BuilderProvisioningState values.
     * 
     * @return known BuilderProvisioningState values.
     */
    public static Collection<BuilderProvisioningState> values() {
        return values(BuilderProvisioningState.class);
    }
}
