// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.BuilderResourceUpdateProperties;
import java.io.IOException;
import java.util.Map;

/**
 * The type used for update operations of the BuilderResource.
 */
@Fluent
public final class BuilderResourceUpdate implements JsonSerializable<BuilderResourceUpdate> {
    /*
     * The managed service identities assigned to this resource.
     */
    private ManagedServiceIdentity identity;

    /*
     * Resource tags.
     */
    private Map<String, String> tags;

    /*
     * The updatable properties of the BuilderResource.
     */
    private BuilderResourceUpdateProperties innerProperties;

    /**
     * Creates an instance of BuilderResourceUpdate class.
     */
    public BuilderResourceUpdate() {
    }

    /**
     * Get the identity property: The managed service identities assigned to this resource.
     * 
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The managed service identities assigned to this resource.
     * 
     * @param identity the identity value to set.
     * @return the BuilderResourceUpdate object itself.
     */
    public BuilderResourceUpdate withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the BuilderResourceUpdate object itself.
     */
    public BuilderResourceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: The updatable properties of the BuilderResource.
     * 
     * @return the innerProperties value.
     */
    private BuilderResourceUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the environmentId property: Resource ID of the container apps environment that the builder is associated
     * with.
     * 
     * @return the environmentId value.
     */
    public String environmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentId();
    }

    /**
     * Set the environmentId property: Resource ID of the container apps environment that the builder is associated
     * with.
     * 
     * @param environmentId the environmentId value to set.
     * @return the BuilderResourceUpdate object itself.
     */
    public BuilderResourceUpdate withEnvironmentId(String environmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BuilderResourceUpdateProperties();
        }
        this.innerProperties().withEnvironmentId(environmentId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuilderResourceUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuilderResourceUpdate if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BuilderResourceUpdate.
     */
    public static BuilderResourceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuilderResourceUpdate deserializedBuilderResourceUpdate = new BuilderResourceUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identity".equals(fieldName)) {
                    deserializedBuilderResourceUpdate.identity = ManagedServiceIdentity.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBuilderResourceUpdate.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedBuilderResourceUpdate.innerProperties
                        = BuilderResourceUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBuilderResourceUpdate;
        });
    }
}
