// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties for a certificate stored in a Key Vault.
 */
@Fluent
public final class CertificateKeyVaultProperties implements JsonSerializable<CertificateKeyVaultProperties> {
    /*
     * Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned
     * identity.
     */
    private String identity;

    /*
     * URL pointing to the Azure Key Vault secret that holds the certificate.
     */
    private String keyVaultUrl;

    /**
     * Creates an instance of CertificateKeyVaultProperties class.
     */
    public CertificateKeyVaultProperties() {
    }

    /**
     * Get the identity property: Resource ID of a managed identity to authenticate with Azure Key Vault, or System to
     * use a system-assigned identity.
     * 
     * @return the identity value.
     */
    public String identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Resource ID of a managed identity to authenticate with Azure Key Vault, or System to
     * use a system-assigned identity.
     * 
     * @param identity the identity value to set.
     * @return the CertificateKeyVaultProperties object itself.
     */
    public CertificateKeyVaultProperties withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the keyVaultUrl property: URL pointing to the Azure Key Vault secret that holds the certificate.
     * 
     * @return the keyVaultUrl value.
     */
    public String keyVaultUrl() {
        return this.keyVaultUrl;
    }

    /**
     * Set the keyVaultUrl property: URL pointing to the Azure Key Vault secret that holds the certificate.
     * 
     * @param keyVaultUrl the keyVaultUrl value to set.
     * @return the CertificateKeyVaultProperties object itself.
     */
    public CertificateKeyVaultProperties withKeyVaultUrl(String keyVaultUrl) {
        this.keyVaultUrl = keyVaultUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("identity", this.identity);
        jsonWriter.writeStringField("keyVaultUrl", this.keyVaultUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateKeyVaultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateKeyVaultProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateKeyVaultProperties.
     */
    public static CertificateKeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateKeyVaultProperties deserializedCertificateKeyVaultProperties
                = new CertificateKeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identity".equals(fieldName)) {
                    deserializedCertificateKeyVaultProperties.identity = reader.getString();
                } else if ("keyVaultUrl".equals(fieldName)) {
                    deserializedCertificateKeyVaultProperties.keyVaultUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateKeyVaultProperties;
        });
    }
}
