// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The type of the certificate. Allowed values are `ServerSSLCertificate` and `ImagePullTrustedCA`.
 */
public final class CertificateType extends ExpandableStringEnum<CertificateType> {
    /**
     * Static value ServerSSLCertificate for CertificateType.
     */
    public static final CertificateType SERVER_SSLCERTIFICATE = fromString("ServerSSLCertificate");

    /**
     * Static value ImagePullTrustedCA for CertificateType.
     */
    public static final CertificateType IMAGE_PULL_TRUSTED_CA = fromString("ImagePullTrustedCA");

    /**
     * Creates a new instance of CertificateType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CertificateType() {
    }

    /**
     * Creates or finds a CertificateType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CertificateType.
     */
    public static CertificateType fromString(String name) {
        return fromString(name, CertificateType.class);
    }

    /**
     * Gets known CertificateType values.
     * 
     * @return known CertificateType values.
     */
    public static Collection<CertificateType> values() {
        return values(CertificateType.class);
    }
}
