// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentInner;
import java.io.IOException;
import java.util.List;

/**
 * Collection of connectedEnvironments.
 */
@Fluent
public final class ConnectedEnvironmentCollection implements JsonSerializable<ConnectedEnvironmentCollection> {
    /*
     * Collection of resources.
     */
    private List<ConnectedEnvironmentInner> value;

    /*
     * Link to next page of resources.
     */
    private String nextLink;

    /**
     * Creates an instance of ConnectedEnvironmentCollection class.
     */
    public ConnectedEnvironmentCollection() {
    }

    /**
     * Get the value property: Collection of resources.
     * 
     * @return the value value.
     */
    public List<ConnectedEnvironmentInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of resources.
     * 
     * @param value the value value to set.
     * @return the ConnectedEnvironmentCollection object itself.
     */
    public ConnectedEnvironmentCollection withValue(List<ConnectedEnvironmentInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedEnvironmentCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedEnvironmentCollection if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectedEnvironmentCollection.
     */
    public static ConnectedEnvironmentCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedEnvironmentCollection deserializedConnectedEnvironmentCollection
                = new ConnectedEnvironmentCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ConnectedEnvironmentInner> value
                        = reader.readArray(reader1 -> ConnectedEnvironmentInner.fromJson(reader1));
                    deserializedConnectedEnvironmentCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedConnectedEnvironmentCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedEnvironmentCollection;
        });
    }
}
