// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Storage properties.
 */
@Fluent
public final class ConnectedEnvironmentStorageProperties
    implements JsonSerializable<ConnectedEnvironmentStorageProperties> {
    /*
     * Azure file properties
     */
    private AzureFileProperties azureFile;

    /*
     * SMB storage properties
     */
    private SmbStorage smb;

    /**
     * Creates an instance of ConnectedEnvironmentStorageProperties class.
     */
    public ConnectedEnvironmentStorageProperties() {
    }

    /**
     * Get the azureFile property: Azure file properties.
     * 
     * @return the azureFile value.
     */
    public AzureFileProperties azureFile() {
        return this.azureFile;
    }

    /**
     * Set the azureFile property: Azure file properties.
     * 
     * @param azureFile the azureFile value to set.
     * @return the ConnectedEnvironmentStorageProperties object itself.
     */
    public ConnectedEnvironmentStorageProperties withAzureFile(AzureFileProperties azureFile) {
        this.azureFile = azureFile;
        return this;
    }

    /**
     * Get the smb property: SMB storage properties.
     * 
     * @return the smb value.
     */
    public SmbStorage smb() {
        return this.smb;
    }

    /**
     * Set the smb property: SMB storage properties.
     * 
     * @param smb the smb value to set.
     * @return the ConnectedEnvironmentStorageProperties object itself.
     */
    public ConnectedEnvironmentStorageProperties withSmb(SmbStorage smb) {
        this.smb = smb;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (azureFile() != null) {
            azureFile().validate();
        }
        if (smb() != null) {
            smb().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureFile", this.azureFile);
        jsonWriter.writeJsonField("smb", this.smb);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedEnvironmentStorageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedEnvironmentStorageProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectedEnvironmentStorageProperties.
     */
    public static ConnectedEnvironmentStorageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedEnvironmentStorageProperties deserializedConnectedEnvironmentStorageProperties
                = new ConnectedEnvironmentStorageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("azureFile".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageProperties.azureFile = AzureFileProperties.fromJson(reader);
                } else if ("smb".equals(fieldName)) {
                    deserializedConnectedEnvironmentStorageProperties.smb = SmbStorage.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedEnvironmentStorageProperties;
        });
    }
}
