// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of ConnectedEnvironments.
 */
public interface ConnectedEnvironments {
    /**
     * Get all connectedEnvironments for a subscription.
     * 
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all connectedEnvironments for a subscription as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ConnectedEnvironment> list();

    /**
     * Get all connectedEnvironments for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all connectedEnvironments for a subscription as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ConnectedEnvironment> list(Context context);

    /**
     * Get all connectedEnvironments in a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all connectedEnvironments in a resource group as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ConnectedEnvironment> listByResourceGroup(String resourceGroupName);

    /**
     * Get all connectedEnvironments in a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all connectedEnvironments in a resource group as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ConnectedEnvironment> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Get the properties of an connectedEnvironment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connectedEnvironment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of an connectedEnvironment along with {@link Response}.
     */
    Response<ConnectedEnvironment> getByResourceGroupWithResponse(String resourceGroupName,
        String connectedEnvironmentName, Context context);

    /**
     * Get the properties of an connectedEnvironment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connectedEnvironment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of an connectedEnvironment.
     */
    ConnectedEnvironment getByResourceGroup(String resourceGroupName, String connectedEnvironmentName);

    /**
     * Delete an connectedEnvironment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connectedEnvironment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByResourceGroup(String resourceGroupName, String connectedEnvironmentName);

    /**
     * Delete an connectedEnvironment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connectedEnvironment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String connectedEnvironmentName, Context context);

    /**
     * Update connected Environment's properties.
     * 
     * Patches a Managed Environment. Only patching of tags is supported currently.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connectedEnvironment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an environment for Kubernetes cluster specialized for web workloads by Azure App Service along with
     * {@link Response}.
     */
    Response<ConnectedEnvironment> updateWithResponse(String resourceGroupName, String connectedEnvironmentName,
        Context context);

    /**
     * Update connected Environment's properties.
     * 
     * Patches a Managed Environment. Only patching of tags is supported currently.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the connectedEnvironment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an environment for Kubernetes cluster specialized for web workloads by Azure App Service.
     */
    ConnectedEnvironment update(String resourceGroupName, String connectedEnvironmentName);

    /**
     * Checks the resource connectedEnvironmentName availability.
     * 
     * Checks if resource connectedEnvironmentName is available.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the Managed Environment.
     * @param checkNameAvailabilityRequest The check connectedEnvironmentName availability request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the check availability result along with {@link Response}.
     */
    Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(String resourceGroupName,
        String connectedEnvironmentName, CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context);

    /**
     * Checks the resource connectedEnvironmentName availability.
     * 
     * Checks if resource connectedEnvironmentName is available.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param connectedEnvironmentName Name of the Managed Environment.
     * @param checkNameAvailabilityRequest The check connectedEnvironmentName availability request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the check availability result.
     */
    CheckNameAvailabilityResponse checkNameAvailability(String resourceGroupName, String connectedEnvironmentName,
        CheckNameAvailabilityRequest checkNameAvailabilityRequest);

    /**
     * Get the properties of an connectedEnvironment.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of an connectedEnvironment along with {@link Response}.
     */
    ConnectedEnvironment getById(String id);

    /**
     * Get the properties of an connectedEnvironment.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of an connectedEnvironment along with {@link Response}.
     */
    Response<ConnectedEnvironment> getByIdWithResponse(String id, Context context);

    /**
     * Delete an connectedEnvironment.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Delete an connectedEnvironment.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new ConnectedEnvironment resource.
     * 
     * @param name resource name.
     * @return the first stage of the new ConnectedEnvironment definition.
     */
    ConnectedEnvironment.DefinitionStages.Blank define(String name);
}
