// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppAuthTokenInner;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * An immutable client-side representation of ContainerAppAuthToken.
 */
public interface ContainerAppAuthToken {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    String location();

    /**
     * Gets the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the token property: Auth token value.
     * 
     * @return the token value.
     */
    String token();

    /**
     * Gets the expires property: Token expiration date.
     * 
     * @return the expires value.
     */
    OffsetDateTime expires();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppAuthTokenInner object.
     * 
     * @return the inner object.
     */
    ContainerAppAuthTokenInner innerModel();
}
