// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Current running state of the container.
 */
public final class ContainerAppContainerRunningState extends ExpandableStringEnum<ContainerAppContainerRunningState> {
    /**
     * Static value Running for ContainerAppContainerRunningState.
     */
    public static final ContainerAppContainerRunningState RUNNING = fromString("Running");

    /**
     * Static value Terminated for ContainerAppContainerRunningState.
     */
    public static final ContainerAppContainerRunningState TERMINATED = fromString("Terminated");

    /**
     * Static value Waiting for ContainerAppContainerRunningState.
     */
    public static final ContainerAppContainerRunningState WAITING = fromString("Waiting");

    /**
     * Creates a new instance of ContainerAppContainerRunningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ContainerAppContainerRunningState() {
    }

    /**
     * Creates or finds a ContainerAppContainerRunningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContainerAppContainerRunningState.
     */
    public static ContainerAppContainerRunningState fromString(String name) {
        return fromString(name, ContainerAppContainerRunningState.class);
    }

    /**
     * Gets known ContainerAppContainerRunningState values.
     * 
     * @return known ContainerAppContainerRunningState values.
     */
    public static Collection<ContainerAppContainerRunningState> values() {
        return values(ContainerAppContainerRunningState.class);
    }
}
