// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * HTTPHeader describes a custom header to be used in HTTP probes.
 */
@Fluent
public final class ContainerAppProbeHttpGetHttpHeadersItem
    implements JsonSerializable<ContainerAppProbeHttpGetHttpHeadersItem> {
    /*
     * The header field name
     */
    private String name;

    /*
     * The header field value
     */
    private String value;

    /**
     * Creates an instance of ContainerAppProbeHttpGetHttpHeadersItem class.
     */
    public ContainerAppProbeHttpGetHttpHeadersItem() {
    }

    /**
     * Get the name property: The header field name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The header field name.
     * 
     * @param name the name value to set.
     * @return the ContainerAppProbeHttpGetHttpHeadersItem object itself.
     */
    public ContainerAppProbeHttpGetHttpHeadersItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The header field value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The header field value.
     * 
     * @param value the value value to set.
     * @return the ContainerAppProbeHttpGetHttpHeadersItem object itself.
     */
    public ContainerAppProbeHttpGetHttpHeadersItem withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model ContainerAppProbeHttpGetHttpHeadersItem"));
        }
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model ContainerAppProbeHttpGetHttpHeadersItem"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerAppProbeHttpGetHttpHeadersItem.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAppProbeHttpGetHttpHeadersItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAppProbeHttpGetHttpHeadersItem if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerAppProbeHttpGetHttpHeadersItem.
     */
    public static ContainerAppProbeHttpGetHttpHeadersItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppProbeHttpGetHttpHeadersItem deserializedContainerAppProbeHttpGetHttpHeadersItem
                = new ContainerAppProbeHttpGetHttpHeadersItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedContainerAppProbeHttpGetHttpHeadersItem.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedContainerAppProbeHttpGetHttpHeadersItem.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAppProbeHttpGetHttpHeadersItem;
        });
    }
}
