// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App auto patch configuration.
 */
@Fluent
public final class ContainerAppPropertiesPatchingConfiguration
    implements JsonSerializable<ContainerAppPropertiesPatchingConfiguration> {
    /*
     * Patching mode for the container app. Null or default in this field will be interpreted as Automatic by RP.
     * Automatic mode will automatically apply available patches. Manual mode will require the user to manually apply
     * patches. Disabled mode will stop patch detection and auto patching.
     */
    private PatchingMode patchingMode;

    /**
     * Creates an instance of ContainerAppPropertiesPatchingConfiguration class.
     */
    public ContainerAppPropertiesPatchingConfiguration() {
    }

    /**
     * Get the patchingMode property: Patching mode for the container app. Null or default in this field will be
     * interpreted as Automatic by RP. Automatic mode will automatically apply available patches. Manual mode will
     * require the user to manually apply patches. Disabled mode will stop patch detection and auto patching.
     * 
     * @return the patchingMode value.
     */
    public PatchingMode patchingMode() {
        return this.patchingMode;
    }

    /**
     * Set the patchingMode property: Patching mode for the container app. Null or default in this field will be
     * interpreted as Automatic by RP. Automatic mode will automatically apply available patches. Manual mode will
     * require the user to manually apply patches. Disabled mode will stop patch detection and auto patching.
     * 
     * @param patchingMode the patchingMode value to set.
     * @return the ContainerAppPropertiesPatchingConfiguration object itself.
     */
    public ContainerAppPropertiesPatchingConfiguration withPatchingMode(PatchingMode patchingMode) {
        this.patchingMode = patchingMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("patchingMode", this.patchingMode == null ? null : this.patchingMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAppPropertiesPatchingConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAppPropertiesPatchingConfiguration if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerAppPropertiesPatchingConfiguration.
     */
    public static ContainerAppPropertiesPatchingConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppPropertiesPatchingConfiguration deserializedContainerAppPropertiesPatchingConfiguration
                = new ContainerAppPropertiesPatchingConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("patchingMode".equals(fieldName)) {
                    deserializedContainerAppPropertiesPatchingConfiguration.patchingMode
                        = PatchingMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAppPropertiesPatchingConfiguration;
        });
    }
}
