// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Current running state of the replica.
 */
public final class ContainerAppReplicaRunningState extends ExpandableStringEnum<ContainerAppReplicaRunningState> {
    /**
     * Static value Running for ContainerAppReplicaRunningState.
     */
    public static final ContainerAppReplicaRunningState RUNNING = fromString("Running");

    /**
     * Static value NotRunning for ContainerAppReplicaRunningState.
     */
    public static final ContainerAppReplicaRunningState NOT_RUNNING = fromString("NotRunning");

    /**
     * Static value Unknown for ContainerAppReplicaRunningState.
     */
    public static final ContainerAppReplicaRunningState UNKNOWN = fromString("Unknown");

    /**
     * Creates a new instance of ContainerAppReplicaRunningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ContainerAppReplicaRunningState() {
    }

    /**
     * Creates or finds a ContainerAppReplicaRunningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContainerAppReplicaRunningState.
     */
    public static ContainerAppReplicaRunningState fromString(String name) {
        return fromString(name, ContainerAppReplicaRunningState.class);
    }

    /**
     * Gets known ContainerAppReplicaRunningState values.
     * 
     * @return known ContainerAppReplicaRunningState values.
     */
    public static Collection<ContainerAppReplicaRunningState> values() {
        return values(ContainerAppReplicaRunningState.class);
    }
}
